/* $Id: glos2.h,v 1.1 2000-01-27 21:49:11 sandervl Exp $ */
#ifndef __glos2_h_
#define __glos2_h_

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned long GLenum;
typedef unsigned char GLboolean;
typedef unsigned long GLbitfield;
typedef signed char GLbyte;
typedef short GLshort;
typedef long GLint;
typedef long GLsizei;
typedef unsigned char GLubyte;
typedef unsigned short GLushort;
typedef unsigned long GLuint;
typedef float GLfloat;
typedef float GLclampf;
typedef double GLdouble;
typedef double GLclampd;
typedef void GLvoid;

extern void APIENTRY OS2glAccum (GLenum op, GLfloat value);
extern void APIENTRY OS2glAlphaFunc (GLenum func, GLclampf ref);
extern GLboolean APIENTRY OS2glAreTexturesResident (GLsizei n, const GLuint *textures, GLboolean *residences);
extern void APIENTRY OS2glArrayElement (GLint i);
extern void APIENTRY OS2glBegin (GLenum mode);
extern void APIENTRY OS2glBindTexture (GLenum target, GLuint texture);
extern void APIENTRY OS2glBitmap (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
extern void APIENTRY OS2glBlendEquation (GLenum mode);
extern void APIENTRY OS2glBlendFunc (GLenum sfactor, GLenum dfactor);
extern void APIENTRY OS2glCallList (GLuint list);
extern void APIENTRY OS2glCallLists (GLsizei n, GLenum type, const GLvoid *lists);
extern void APIENTRY OS2glClear (GLbitfield mask);
extern void APIENTRY OS2glClearAccum (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
extern void APIENTRY OS2glClearColor (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
extern void APIENTRY OS2glClearDepth (GLclampd depth);
extern void APIENTRY OS2glClearIndex (GLfloat c);
extern void APIENTRY OS2glClearStencil (GLint s);
extern void APIENTRY OS2glClipPlane (GLenum plane, const GLdouble *equation);
extern void APIENTRY OS2glColor3b (GLbyte red, GLbyte green, GLbyte blue);
extern void APIENTRY OS2glColor3bv (const GLbyte *v);
extern void APIENTRY OS2glColor3d (GLdouble red, GLdouble green, GLdouble blue);
extern void APIENTRY OS2glColor3dv (const GLdouble *v);
extern void APIENTRY OS2glColor3f (GLfloat red, GLfloat green, GLfloat blue);
extern void APIENTRY OS2glColor3fv (const GLfloat *v);
extern void APIENTRY OS2glColor3i (GLint red, GLint green, GLint blue);
extern void APIENTRY OS2glColor3iv (const GLint *v);
extern void APIENTRY OS2glColor3s (GLshort red, GLshort green, GLshort blue);
extern void APIENTRY OS2glColor3sv (const GLshort *v);
extern void APIENTRY OS2glColor3ub (GLubyte red, GLubyte green, GLubyte blue);
extern void APIENTRY OS2glColor3ubv (const GLubyte *v);
extern void APIENTRY OS2glColor3ui (GLuint red, GLuint green, GLuint blue);
extern void APIENTRY OS2glColor3uiv (const GLuint *v);
extern void APIENTRY OS2glColor3us (GLushort red, GLushort green, GLushort blue);
extern void APIENTRY OS2glColor3usv (const GLushort *v);
extern void APIENTRY OS2glColor4b (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
extern void APIENTRY OS2glColor4bv (const GLbyte *v);
extern void APIENTRY OS2glColor4d (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
extern void APIENTRY OS2glColor4dv (const GLdouble *v);
extern void APIENTRY OS2glColor4f (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
extern void APIENTRY OS2glColor4fv (const GLfloat *v);
extern void APIENTRY OS2glColor4i (GLint red, GLint green, GLint blue, GLint alpha);
extern void APIENTRY OS2glColor4iv (const GLint *v);
extern void APIENTRY OS2glColor4s (GLshort red, GLshort green, GLshort blue, GLshort alpha);
extern void APIENTRY OS2glColor4sv (const GLshort *v);
extern void APIENTRY OS2glColor4ub (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
extern void APIENTRY OS2glColor4ubv (const GLubyte *v);
extern void APIENTRY OS2glColor4ui (GLuint red, GLuint green, GLuint blue, GLuint alpha);
extern void APIENTRY OS2glColor4uiv (const GLuint *v);
extern void APIENTRY OS2glColor4us (GLushort red, GLushort green, GLushort blue, GLushort alpha);
extern void APIENTRY OS2glColor4usv (const GLushort *v);
extern void APIENTRY OS2glColorMask (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
extern void APIENTRY OS2glColorMaterial (GLenum face, GLenum mode);
extern void APIENTRY OS2glColorPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
extern void APIENTRY OS2glCopyPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
extern void APIENTRY OS2glCopyTexImage1D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
extern void APIENTRY OS2glCopyTexImage2D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
extern void APIENTRY OS2glCopyTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
extern void APIENTRY OS2glCopyTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
extern void APIENTRY OS2glCullFace (GLenum mode);
extern void APIENTRY OS2glDeleteLists (GLuint list, GLsizei range);
extern void APIENTRY OS2glDeleteTextures (GLsizei n, const GLuint *textures);
extern void APIENTRY OS2glDepthFunc (GLenum func);
extern void APIENTRY OS2glDepthMask (GLboolean flag);
extern void APIENTRY OS2glDepthRange (GLclampd near, GLclampd far);
extern void APIENTRY OS2glDisable (GLenum cap);
extern void APIENTRY OS2glDisableClientState (GLenum array);
extern void APIENTRY OS2glDrawArrays (GLenum mode, GLint first, GLsizei count);
extern void APIENTRY OS2glDrawBuffer (GLenum mode);
extern void APIENTRY OS2glDrawElements (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
extern void APIENTRY OS2glDrawPixels (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
extern void APIENTRY OS2glEdgeFlag (GLboolean flag);
extern void APIENTRY OS2glEdgeFlagPointer (GLsizei stride, const GLboolean *pointer);
extern void APIENTRY OS2glEdgeFlagv (const GLboolean *flag);
extern void APIENTRY OS2glEnable (GLenum cap);
extern void APIENTRY OS2glEnableClientState (GLenum array);
extern void APIENTRY OS2glEnd (void);
extern void APIENTRY OS2glEndList (void);
extern void APIENTRY OS2glEvalCoord1d (GLdouble u);
extern void APIENTRY OS2glEvalCoord1dv (const GLdouble *u);
extern void APIENTRY OS2glEvalCoord1f (GLfloat u);
extern void APIENTRY OS2glEvalCoord1fv (const GLfloat *u);
extern void APIENTRY OS2glEvalCoord2d (GLdouble u, GLdouble v);
extern void APIENTRY OS2glEvalCoord2dv (const GLdouble *u);
extern void APIENTRY OS2glEvalCoord2f (GLfloat u, GLfloat v);
extern void APIENTRY OS2glEvalCoord2fv (const GLfloat *u);
extern void APIENTRY OS2glEvalMesh1 (GLenum mode, GLint i1, GLint i2);
extern void APIENTRY OS2glEvalMesh2 (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
extern void APIENTRY OS2glEvalPoint1 (GLint i);
extern void APIENTRY OS2glEvalPoint2 (GLint i, GLint j);
extern void APIENTRY OS2glFeedbackBuffer (GLsizei size, GLenum type, GLfloat *buffer);
extern void APIENTRY OS2glFinish (void);
extern void APIENTRY OS2glFlush (void);
extern void APIENTRY OS2glFogf (GLenum pname, GLfloat param);
extern void APIENTRY OS2glFogfv (GLenum pname, const GLfloat *params);
extern void APIENTRY OS2glFogi (GLenum pname, GLint param);
extern void APIENTRY OS2glFogiv (GLenum pname, const GLint *params);
extern void APIENTRY OS2glFrontFace (GLenum mode);
extern void APIENTRY OS2glFrustum (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble near, GLdouble far);
extern GLuint APIENTRY OS2glGenLists (GLsizei range);
extern void APIENTRY OS2glGenTextures (GLsizei n, GLuint *textures);
extern void APIENTRY OS2glGetBooleanv (GLenum pname, GLboolean *params);
extern void APIENTRY OS2glGetClipPlane (GLenum plane, GLdouble *equation);
extern void APIENTRY OS2glGetDoublev (GLenum pname, GLdouble *params);
extern GLenum APIENTRY OS2glGetError (void);
extern void APIENTRY OS2glGetFloatv (GLenum pname, GLfloat *params);
extern void APIENTRY OS2glGetIntegerv (GLenum pname, GLint *params);
extern void APIENTRY OS2glGetLightfv (GLenum light, GLenum pname, GLfloat *params);
extern void APIENTRY OS2glGetLightiv (GLenum light, GLenum pname, GLint *params);
extern void APIENTRY OS2glGetMapdv (GLenum target, GLenum query, GLdouble *v);
extern void APIENTRY OS2glGetMapfv (GLenum target, GLenum query, GLfloat *v);
extern void APIENTRY OS2glGetMapiv (GLenum target, GLenum query, GLint *v);
extern void APIENTRY OS2glGetMaterialfv (GLenum face, GLenum pname, GLfloat *params);
extern void APIENTRY OS2glGetMaterialiv (GLenum face, GLenum pname, GLint *params);
extern void APIENTRY OS2glGetPixelMapfv (GLenum map, GLfloat *values);
extern void APIENTRY OS2glGetPixelMapuiv (GLenum map, GLuint *values);
extern void APIENTRY OS2glGetPixelMapusv (GLenum map, GLushort *values);
extern void APIENTRY OS2glGetPointerv (GLenum pname, GLvoid *params);
extern void APIENTRY OS2glGetPolygonStipple (GLubyte *mask);
extern const GLubyte * APIENTRY OS2glGetString (GLenum name);
extern void APIENTRY OS2glGetTexEnvfv (GLenum target, GLenum pname, GLfloat *params);
extern void APIENTRY OS2glGetTexEnviv (GLenum target, GLenum pname, GLint *params);
extern void APIENTRY OS2glGetTexGendv (GLenum coord, GLenum pname, GLdouble *params);
extern void APIENTRY OS2glGetTexGenfv (GLenum coord, GLenum pname, GLfloat *params);
extern void APIENTRY OS2glGetTexGeniv (GLenum coord, GLenum pname, GLint *params);
extern void APIENTRY OS2glGetTexImage (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
extern void APIENTRY OS2glGetTexLevelParameterfv (GLenum target, GLint level, GLenum pname, GLfloat *params);
extern void APIENTRY OS2glGetTexLevelParameteriv (GLenum target, GLint level, GLenum pname, GLint *params);
extern void APIENTRY OS2glGetTexParameterfv (GLenum target, GLenum pname, GLfloat *params);
extern void APIENTRY OS2glGetTexParameteriv (GLenum target, GLenum pname, GLint *params);
extern void APIENTRY OS2glHint (GLenum target, GLenum mode);
extern void APIENTRY OS2glIndexMask (GLuint mask);
extern void APIENTRY OS2glIndexPointer (GLenum type, GLsizei stride, const GLvoid *pointer);
extern void APIENTRY OS2glIndexd (GLdouble c);
extern void APIENTRY OS2glIndexdv (const GLdouble *c);
extern void APIENTRY OS2glIndexf (GLfloat c);
extern void APIENTRY OS2glIndexfv (const GLfloat *c);
extern void APIENTRY OS2glIndexi (GLint c);
extern void APIENTRY OS2glIndexiv (const GLint *c);
extern void APIENTRY OS2glIndexs (GLshort c);
extern void APIENTRY OS2glIndexsv (const GLshort *c);
extern void APIENTRY OS2glIndexub (GLubyte c);
extern void APIENTRY OS2glIndexubv (const GLubyte *c);
extern void APIENTRY OS2glInitNames (void);
extern void APIENTRY OS2glInterleavedArrays (GLenum format, GLsizei stride, const GLvoid *pointer);
extern GLboolean APIENTRY OS2glIsEnabled (GLenum cap);
extern GLboolean APIENTRY OS2glIsList (GLuint list);
extern GLboolean APIENTRY OS2glIsTexture (GLuint texture);
extern void APIENTRY OS2glLightModelf (GLenum pname, GLfloat param);
extern void APIENTRY OS2glLightModelfv (GLenum pname, const GLfloat *params);
extern void APIENTRY OS2glLightModeli (GLenum pname, GLint param);
extern void APIENTRY OS2glLightModeliv (GLenum pname, const GLint *params);
extern void APIENTRY OS2glLightf (GLenum light, GLenum pname, GLfloat param);
extern void APIENTRY OS2glLightfv (GLenum light, GLenum pname, const GLfloat *params);
extern void APIENTRY OS2glLighti (GLenum light, GLenum pname, GLint param);
extern void APIENTRY OS2glLightiv (GLenum light, GLenum pname, const GLint *params);
extern void APIENTRY OS2glLineStipple (GLint factor, GLushort pattern);
extern void APIENTRY OS2glLineWidth (GLfloat width);
extern void APIENTRY OS2glListBase (GLuint base);
extern void APIENTRY OS2glLoadIdentity (void);
extern void APIENTRY OS2glLoadMatrixd (const GLdouble *m);
extern void APIENTRY OS2glLoadMatrixf (const GLfloat *m);
extern void APIENTRY OS2glLoadName (GLuint name);
extern void APIENTRY OS2glLogicOp (GLenum opcode);
extern void APIENTRY OS2glMap1d (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
extern void APIENTRY OS2glMap1f (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
extern void APIENTRY OS2glMap2d (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
extern void APIENTRY OS2glMap2f (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
extern void APIENTRY OS2glMapGrid1d (GLint un, GLdouble u1, GLdouble u2);
extern void APIENTRY OS2glMapGrid1f (GLint un, GLfloat u1, GLfloat u2);
extern void APIENTRY OS2glMapGrid2d (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
extern void APIENTRY OS2glMapGrid2f (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
extern void APIENTRY OS2glMaterialf (GLenum face, GLenum pname, GLfloat param);
extern void APIENTRY OS2glMaterialfv (GLenum face, GLenum pname, const GLfloat *params);
extern void APIENTRY OS2glMateriali (GLenum face, GLenum pname, GLint param);
extern void APIENTRY OS2glMaterialiv (GLenum face, GLenum pname, const GLint *params);
extern void APIENTRY OS2glMatrixMode (GLenum mode);
extern void APIENTRY OS2glMultMatrixd (const GLdouble *m);
extern void APIENTRY OS2glMultMatrixf (const GLfloat *m);
extern void APIENTRY OS2glNewList (GLuint list, GLenum mode);
extern void APIENTRY OS2glNormal3b (GLbyte nx, GLbyte ny, GLbyte nz);
extern void APIENTRY OS2glNormal3bv (const GLbyte *v);
extern void APIENTRY OS2glNormal3d (GLdouble nx, GLdouble ny, GLdouble nz);
extern void APIENTRY OS2glNormal3dv (const GLdouble *v);
extern void APIENTRY OS2glNormal3f (GLfloat nx, GLfloat ny, GLfloat nz);
extern void APIENTRY OS2glNormal3fv (const GLfloat *v);
extern void APIENTRY OS2glNormal3i (GLint nx, GLint ny, GLint nz);
extern void APIENTRY OS2glNormal3iv (const GLint *v);
extern void APIENTRY OS2glNormal3s (GLshort nx, GLshort ny, GLshort nz);
extern void APIENTRY OS2glNormal3sv (const GLshort *v);
extern void APIENTRY OS2glNormalPointer (GLenum type, GLsizei stride, const GLvoid *pointer);
extern void APIENTRY OS2glOrtho (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble near, GLdouble far);
extern void APIENTRY OS2glPassThrough (GLfloat token);
extern void APIENTRY OS2glPixelMapfv (GLenum map, GLsizei mapsize, const GLfloat *values);
extern void APIENTRY OS2glPixelMapuiv (GLenum map, GLsizei mapsize, const GLuint *values);
extern void APIENTRY OS2glPixelMapusv (GLenum map, GLsizei mapsize, const GLushort *values);
extern void APIENTRY OS2glPixelStoref (GLenum pname, GLfloat param);
extern void APIENTRY OS2glPixelStorei (GLenum pname, GLint param);
extern void APIENTRY OS2glPixelTransferf (GLenum pname, GLfloat param);
extern void APIENTRY OS2glPixelTransferi (GLenum pname, GLint param);
extern void APIENTRY OS2glPixelZoom (GLfloat xfactor, GLfloat yfactor);
extern void APIENTRY OS2glPointSize (GLfloat size);
extern void APIENTRY OS2glPolygonMode (GLenum face, GLenum mode);
extern void APIENTRY OS2glPolygonOffset (GLfloat factor, GLfloat units);
extern void APIENTRY OS2glPolygonStipple (const GLubyte *mask);
extern void APIENTRY OS2glPopAttrib (void);
extern void APIENTRY OS2glPopClientAttrib (void);
extern void APIENTRY OS2glPopMatrix (void);
extern void APIENTRY OS2glPopName (void);
extern void APIENTRY OS2glPrioritizeTextures (GLsizei n, const GLuint *textures, const GLclampf *priorities);
extern void APIENTRY OS2glPushAttrib (GLbitfield mask);
extern void APIENTRY OS2glPushClientAttrib (GLbitfield mask);
extern void APIENTRY OS2glPushMatrix (void);
extern void APIENTRY OS2glPushName (GLuint name);
extern void APIENTRY OS2glRasterPos2d (GLdouble x, GLdouble y);
extern void APIENTRY OS2glRasterPos2dv (const GLdouble *v);
extern void APIENTRY OS2glRasterPos2f (GLfloat x, GLfloat y);
extern void APIENTRY OS2glRasterPos2fv (const GLfloat *v);
extern void APIENTRY OS2glRasterPos2i (GLint x, GLint y);
extern void APIENTRY OS2glRasterPos2iv (const GLint *v);
extern void APIENTRY OS2glRasterPos2s (GLshort x, GLshort y);
extern void APIENTRY OS2glRasterPos2sv (const GLshort *v);
extern void APIENTRY OS2glRasterPos3d (GLdouble x, GLdouble y, GLdouble z);
extern void APIENTRY OS2glRasterPos3dv (const GLdouble *v);
extern void APIENTRY OS2glRasterPos3f (GLfloat x, GLfloat y, GLfloat z);
extern void APIENTRY OS2glRasterPos3fv (const GLfloat *v);
extern void APIENTRY OS2glRasterPos3i (GLint x, GLint y, GLint z);
extern void APIENTRY OS2glRasterPos3iv (const GLint *v);
extern void APIENTRY OS2glRasterPos3s (GLshort x, GLshort y, GLshort z);
extern void APIENTRY OS2glRasterPos3sv (const GLshort *v);
extern void APIENTRY OS2glRasterPos4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void APIENTRY OS2glRasterPos4dv (const GLdouble *v);
extern void APIENTRY OS2glRasterPos4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void APIENTRY OS2glRasterPos4fv (const GLfloat *v);
extern void APIENTRY OS2glRasterPos4i (GLint x, GLint y, GLint z, GLint w);
extern void APIENTRY OS2glRasterPos4iv (const GLint *v);
extern void APIENTRY OS2glRasterPos4s (GLshort x, GLshort y, GLshort z, GLshort w);
extern void APIENTRY OS2glRasterPos4sv (const GLshort *v);
extern void APIENTRY OS2glReadBuffer (GLenum mode);
extern void APIENTRY OS2glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
extern void APIENTRY OS2glRectd (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
extern void APIENTRY OS2glRectdv (const GLdouble *v1, const GLdouble *v2);
extern void APIENTRY OS2glRectf (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
extern void APIENTRY OS2glRectfv (const GLfloat *v1, const GLfloat *v2);
extern void APIENTRY OS2glRecti (GLint x1, GLint y1, GLint x2, GLint y2);
extern void APIENTRY OS2glRectiv (const GLint *v1, const GLint *v2);
extern void APIENTRY OS2glRects (GLshort x1, GLshort y1, GLshort x2, GLshort y2);
extern void APIENTRY OS2glRectsv (const GLshort *v1, const GLshort *v2);
extern GLint APIENTRY OS2glRenderMode (GLenum mode);
extern void APIENTRY OS2glRotated (GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
extern void APIENTRY OS2glRotatef (GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
extern void APIENTRY OS2glScaled (GLdouble x, GLdouble y, GLdouble z);
extern void APIENTRY OS2glScalef (GLfloat x, GLfloat y, GLfloat z);
extern void APIENTRY OS2glScissor (GLint x, GLint y, GLsizei width, GLsizei height);
extern void APIENTRY OS2glSelectBuffer (GLsizei size, GLuint *buffer);
extern void APIENTRY OS2glShadeModel (GLenum mode);
extern void APIENTRY OS2glStencilFunc (GLenum func, GLint ref, GLuint mask);
extern void APIENTRY OS2glStencilMask (GLuint mask);
extern void APIENTRY OS2glStencilOp (GLenum fail, GLenum zfail, GLenum zpass);
extern void APIENTRY OS2glTexCoord1d (GLdouble s);
extern void APIENTRY OS2glTexCoord1dv (const GLdouble *v);
extern void APIENTRY OS2glTexCoord1f (GLfloat s);
extern void APIENTRY OS2glTexCoord1fv (const GLfloat *v);
extern void APIENTRY OS2glTexCoord1i (GLint s);
extern void APIENTRY OS2glTexCoord1iv (const GLint *v);
extern void APIENTRY OS2glTexCoord1s (GLshort s);
extern void APIENTRY OS2glTexCoord1sv (const GLshort *v);
extern void APIENTRY OS2glTexCoord2d (GLdouble s, GLdouble t);
extern void APIENTRY OS2glTexCoord2dv (const GLdouble *v);
extern void APIENTRY OS2glTexCoord2f (GLfloat s, GLfloat t);
extern void APIENTRY OS2glTexCoord2fv (const GLfloat *v);
extern void APIENTRY OS2glTexCoord2i (GLint s, GLint t);
extern void APIENTRY OS2glTexCoord2iv (const GLint *v);
extern void APIENTRY OS2glTexCoord2s (GLshort s, GLshort t);
extern void APIENTRY OS2glTexCoord2sv (const GLshort *v);
extern void APIENTRY OS2glTexCoord3d (GLdouble s, GLdouble t, GLdouble r);
extern void APIENTRY OS2glTexCoord3dv (const GLdouble *v);
extern void APIENTRY OS2glTexCoord3f (GLfloat s, GLfloat t, GLfloat r);
extern void APIENTRY OS2glTexCoord3fv (const GLfloat *v);
extern void APIENTRY OS2glTexCoord3i (GLint s, GLint t, GLint r);
extern void APIENTRY OS2glTexCoord3iv (const GLint *v);
extern void APIENTRY OS2glTexCoord3s (GLshort s, GLshort t, GLshort r);
extern void APIENTRY OS2glTexCoord3sv (const GLshort *v);
extern void APIENTRY OS2glTexCoord4d (GLdouble s, GLdouble t, GLdouble r, GLdouble q);
extern void APIENTRY OS2glTexCoord4dv (const GLdouble *v);
extern void APIENTRY OS2glTexCoord4f (GLfloat s, GLfloat t, GLfloat r, GLfloat q);
extern void APIENTRY OS2glTexCoord4fv (const GLfloat *v);
extern void APIENTRY OS2glTexCoord4i (GLint s, GLint t, GLint r, GLint q);
extern void APIENTRY OS2glTexCoord4iv (const GLint *v);
extern void APIENTRY OS2glTexCoord4s (GLshort s, GLshort t, GLshort r, GLshort q);
extern void APIENTRY OS2glTexCoord4sv (const GLshort *v);
extern void APIENTRY OS2glTexCoordPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
extern void APIENTRY OS2glTexEnvf (GLenum target, GLenum pname, GLfloat param);
extern void APIENTRY OS2glTexEnvfv (GLenum target, GLenum pname, const GLfloat *params);
extern void APIENTRY OS2glTexEnvi (GLenum target, GLenum pname, GLint param);
extern void APIENTRY OS2glTexEnviv (GLenum target, GLenum pname, const GLint *params);
extern void APIENTRY OS2glTexGend (GLenum coord, GLenum pname, GLdouble param);
extern void APIENTRY OS2glTexGendv (GLenum coord, GLenum pname, const GLdouble *params);
extern void APIENTRY OS2glTexGenf (GLenum coord, GLenum pname, GLfloat param);
extern void APIENTRY OS2glTexGenfv (GLenum coord, GLenum pname, const GLfloat *params);
extern void APIENTRY OS2glTexGeni (GLenum coord, GLenum pname, GLint param);
extern void APIENTRY OS2glTexGeniv (GLenum coord, GLenum pname, const GLint *params);
extern void APIENTRY OS2glTexImage1D (GLenum target, GLint level, GLint components, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void APIENTRY OS2glTexImage2D (GLenum target, GLint level, GLint components, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void APIENTRY OS2glTexParameterf (GLenum target, GLenum pname, GLfloat param);
extern void APIENTRY OS2glTexParameterfv (GLenum target, GLenum pname, const GLfloat *params);
extern void APIENTRY OS2glTexParameteri (GLenum target, GLenum pname, GLint param);
extern void APIENTRY OS2glTexParameteriv (GLenum target, GLenum pname, const GLint *params);
extern void APIENTRY OS2glTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
extern void APIENTRY OS2glTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
extern void APIENTRY OS2glTranslated (GLdouble x, GLdouble y, GLdouble z);
extern void APIENTRY OS2glTranslatef (GLfloat x, GLfloat y, GLfloat z);
extern void APIENTRY OS2glVertex2d (GLdouble x, GLdouble y);
extern void APIENTRY OS2glVertex2dv (const GLdouble *v);
extern void APIENTRY OS2glVertex2f (GLfloat x, GLfloat y);
extern void APIENTRY OS2glVertex2fv (const GLfloat *v);
extern void APIENTRY OS2glVertex2i (GLint x, GLint y);
extern void APIENTRY OS2glVertex2iv (const GLint *v);
extern void APIENTRY OS2glVertex2s (GLshort x, GLshort y);
extern void APIENTRY OS2glVertex2sv (const GLshort *v);
extern void APIENTRY OS2glVertex3d (GLdouble x, GLdouble y, GLdouble z);
extern void APIENTRY OS2glVertex3dv (const GLdouble *v);
extern void APIENTRY OS2glVertex3f (GLfloat x, GLfloat y, GLfloat z);
extern void APIENTRY OS2glVertex3fv (const GLfloat *v);
extern void APIENTRY OS2glVertex3i (GLint x, GLint y, GLint z);
extern void APIENTRY OS2glVertex3iv (const GLint *v);
extern void APIENTRY OS2glVertex3s (GLshort x, GLshort y, GLshort z);
extern void APIENTRY OS2glVertex3sv (const GLshort *v);
extern void APIENTRY OS2glVertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void APIENTRY OS2glVertex4dv (const GLdouble *v);
extern void APIENTRY OS2glVertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void APIENTRY OS2glVertex4fv (const GLfloat *v);
extern void APIENTRY OS2glVertex4i (GLint x, GLint y, GLint z, GLint w);
extern void APIENTRY OS2glVertex4iv (const GLint *v);
extern void APIENTRY OS2glVertex4s (GLshort x, GLshort y, GLshort z, GLshort w);
extern void APIENTRY OS2glVertex4sv (const GLshort *v);
extern void APIENTRY OS2glVertexPointer (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid *pointer);
extern void APIENTRY OS2glViewport (GLint x, GLint y, GLsizei width, GLsizei height);

#ifdef __cplusplus
}
#endif

#endif /* __glos2_h_ */
