/* $Id: new.cpp,v 1.2 1999-10-14 01:19:21 bird Exp $
 *
 * new - new and delete operators.
 *
 * Copyright (c) 1998-1999 knut st. osmundsen
 *
 */

/*******************************************************************************
*   Defined Constants                                                          *
*******************************************************************************/
#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOAPI

/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include <os2.h>

#include "new.h"
#include "malloc.h"
#include "log.h"


#pragma info(none)
/**
 * New.
 * @returns   pointer to allocated memory.
 * @param     Size  Size requested.
 */
void *operator new(size_t size)
{
    return malloc(size);
}


/**
 * stub
 */
void *operator new(size_t size, void *location)
{
    dprintf(("operator new(size,location) not implemented\n"));
    return NULL;
}


/**
 * stub
 */
void *operator new[](size_t size)
{
    dprintf(("operator new[](size) not implemented\n"));
    return NULL;
}


/**
 * stub
 */
void *operator new[](size_t size, void *location)
{
    dprintf(("operator new[](size,location) not implemented\n"));
    return NULL;
}

#ifndef __DEBUG_ALLOC__
/**
 * Delete.
 * @param     location  Pointer to memory block which are to be freed.
 */
void operator delete(void *location)
{
    free(location);
}


/**
 * stub
 */
void operator delete[](void *location)
{
    dprintf(("operator delete[](location) - not implemented\n"));
}
#endif

/***
 *  debug!
 ***/

/**
 * New.
 * @returns   pointer to allocated memory.
 * @param     Size  Size requested.
 */
void *operator new(size_t size, const char *filename, size_t lineno)
{
    return malloc(size);
}


/**
 * stub
 */
void *operator new(size_t size, const char *filename, size_t lineno, void *location)
{
    dprintf(("operator new(size,location) not implemented\n"));
    return NULL;
}


/**
 * stub
 */
void *operator new[](size_t size, const char *filename, size_t lineno)
{
    dprintf(("operator new[](size) not implemented\n"));
    return NULL;
}


/**
 * stub
 */
void *operator new[](size_t size, const char *filename, size_t lineno, void *location)
{
    dprintf(("operator new[](size,location) not implemented\n"));
    return NULL;
}

#ifdef __DEBUG_ALLOC__
/**
 * Delete.
 * @param     location  Pointer to memory block which are to be freed.
 */
void operator delete(void *location, const char *filename, size_t lineno)
{
    free(location);
}


/**
 * stub
 */
void operator delete[](void *location, const char *filename, size_t lineno)
{
    dprintf(("operator delete[](location) - not implemented\n"));
}
#endif
