/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Character type querying.
*/

#ifndef _CTYPE_H
#define _CTYPE_H

#include <sys/cdefs.h>
#include <sys/locale.h>

__BEGIN_DECLS

static inline int isalnum (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__UPPER|__LOWER|__DIGIT); }

static inline int isalpha (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__UPPER|__LOWER); }

static inline int iscntrl (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__CNTRL); }

static inline int isdigit (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__DIGIT); }

static inline int isgraph (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__PUNCT|__UPPER|__LOWER|__DIGIT); }

static inline int islower (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__LOWER); }

static inline int isprint (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__PRINT); }

static inline int ispunct (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__PUNCT); }

static inline int isspace (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__SPACE); }

static inline int isupper (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__UPPER); }

static inline int isxdigit (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__XDIGIT); }

static inline int toupper (int _c)
{ return __locale_ctype.upcase [_c & 0xff]; }

static inline int tolower (int _c)
{ return __locale_ctype.locase [_c & 0xff]; }


#if __XSI_VISIBLE
static inline int _toupper (int _c)
{ return __locale_ctype.upcase [_c & 0xff]; }
static inline int _tolower (int _c)
{ return __locale_ctype.locase [_c & 0xff]; }
static inline int isascii (int _c)
{ return !(_c & 0x80); }
static inline int toascii (int _c)
{ return (_c & 0x7f); }
#endif

#if __BSD_VISIBLE
/* @todo int	digittoint(int); */
static inline int isblank (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__BLANK); }
/* @todo int	ishexnumber(int); */
/* @todo int	isideogram(int); */
/* @todo int	isnumber(int); */
/* @todo int	isphonogram(int); */
/* @todo int	isrune(int); */
/* @todo int	isspecial(int); */
#endif

__END_DECLS

#endif /* not _CTYPE_H */
