/* timetabs.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#include <limits.h>
#include <emx/time.h>

/* Day number, relative to 01-Jan-1970, of 01-Jan for the years 1900
   through 2059 */
signed short const _year_day[_YEARS+1] =
{
   -25567,-25202,-24837,-24472,-24107,-23741,-23376,-23011,-22646,-22280,  /* 1900 - 1909 */
   -21915,-21550,-21185,-20819,-20454,-20089,-19724,-19358,-18993,-18628,  /* 1910 - 1919 */
   -18263,-17897,-17532,-17167,-16802,-16436,-16071,-15706,-15341,-14975,  /* 1920 - 1929 */
   -14610,-14245,-13880,-13514,-13149,-12784,-12419,-12053,-11688,-11323,  /* 1930 - 1939 */
   -10958,-10592,-10227, -9862, -9497, -9131, -8766, -8401, -8036, -7670,  /* 1940 - 1949 */
    -7305, -6940, -6575, -6209, -5844, -5479, -5114, -4748, -4383, -4018,  /* 1950 - 1959 */
    -3653, -3287, -2922, -2557, -2192, -1826, -1461, -1096,  -731,  -365,  /* 1960 - 1969 */
        0,   365,   730,  1096,  1461,  1826,  2191,  2557,  2922,  3287,  /* 1970 - 1979 */
     3652,  4018,  4383,  4748,  5113,  5479,  5844,  6209,  6574,  6940,  /* 1980 - 1989 */
     7305,  7670,  8035,  8401,  8766,  9131,  9496,  9862, 10227, 10592,  /* 1990 - 1999 */
    10957, 11323, 11688, 12053, 12418, 12784, 13149, 13514, 13879, 14245,  /* 2000 - 2009 */
    14610, 14975, 15340, 15706, 16071, 16436, 16801, 17167, 17532, 17897,  /* 2010 - 2019 */
    18262, 18628, 18993, 19358, 19723, 20089, 20454, 20819, 21184, 21550,  /* 2020 - 2029 */
    21915, 22280, 22645, 23011, 23376, 23741, 24106, 24472, 24837, 25202,  /* 2030 - 2039 */
    25567, 25933, 26298, 26663, 27028, 27394, 27759, 28124, 28489, 28855,  /* 2040 - 2049 */
    29220, 29585, 29950, 30316, 30681, 31046, 31411, 31777, 32142, 32507,  /* 2050 - 2059 */
    SHRT_MAX
};


/* Day number, relative to 01-Jan, of day 01 for January through
   December. */

unsigned short const _month_day_non_leap[] =
  {0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, USHRT_MAX};

unsigned short const _month_day_leap[] =
  {0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, USHRT_MAX};
