/* Called at startup to register frame unwind info tables and at shutdown
   to deregister FUI tables. Used when frame unwinding info is enabled
   (C++ without --fno-exceptions and without -fsjlj-exceptions). */

extern int __eh_frame__;
extern void __register_frame_table (void *begin);
extern void __deregister_frame (void *begin);
extern void __ehInit (void);
extern void __ehTerm (void);

void __ehTerm (void)
{
  static int done;

  if (!done)
    {
      int *ptr = &__eh_frame__;
      done = 1;
      __deregister_frame (&ptr [*ptr == -2 ? 1 : 2]);
    }
}

void __ehInit (void)
{
  static int done;

  if (!done)
    {
      int *ptr = &__eh_frame__;
      done = 1;
      __register_frame_table (&ptr [*ptr == -2 ? 1 : 2]);
      atexit (__ehTerm);
    }
}
