/* $Id: recvmsg.c 886 2003-12-08 05:45:15Z bird $ */
/** @file
 *
 * recvmsg().
 *
 * Copyright (c) 2003 knut st. osmundsen <bird-srcspam@anduin.net>
 *
 *
 * This file is part of Innotek LIBC.
 *
 * Innotek LIBC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Innotek LIBC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Innotek LIBC; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#include <errno.h>
#include <sys/socket.h>
#include <sys/fcntl.h>
#include <emx/io.h>
#include "socket.h"

int recvmsg(int socket, struct msghdr *msg, int flags)
{
    PLIBCSOCKETFH   pFHSocket = __libsocket_FH(socket);
    if (pFHSocket)
    {
        int rc;
        rc = __libsocket_recvmsg(pFHSocket->iSocket, msg, flags);
        if (rc >= 0)
            return rc;
        __libsocket_setLibcErrno();
    }

    return -1;
}


