/* $Id: sock_errno.c 886 2003-12-08 05:45:15Z bird $
 *
 * Wrapper for sock_errno return values - both modes.
 *
 * Copyright (c) 2003 InnoTek Systemberatung GmbH
 * Author: knut st. osmundsen <bird@anduin.net>
 *
 * All Rights Reserved
 *
 */

/*******************************************************************************
*   Header Files                                                               *
*******************************************************************************/
#include "libc-alias.h"
#include <errno.h>
#include <sys/socket.h>
#include <sys/fcntl.h>
#include <emx/io.h>
#include "socket.h"


/**
 * Get the last socket error number.
 * This wrapper is required to get match our error defines in errno.h. OS/2
 * tcpip uses the FreeBSD / M$C errno.h values with an offset of 10000.
 *
 * @returns libc compatible errno for last socket operation.
 */
int _System sock_errno(void)
{
    /* get the OS/2 error. */
    int err = os2_sock_errno();
    if (err > EOS2_TCPIP_OFFSET && err < EOS2_TCPIP_OFFSET + 1000)
        err -= EOS2_TCPIP_OFFSET;
    return err;
}

