/* sys/sleep.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#define INCL_DOSMISC
#define INCL_DOSPROCESS
#define INCL_FSMACROS
#include <stdlib.h>
#include <os2emx.h>
#include <emx/syscalls.h>
#include "syscalls.h"

unsigned _STD(sleep) (unsigned sec)
{
  FS_VAR();
  if (sec == 0)
    {
      FS_SAVE_LOAD();
      DosSleep (0);
      FS_RESTORE();
      return 0;
    }
  else
    {
      ULONG start, stop, elapsed;

      FS_SAVE_LOAD();
      DosQuerySysInfo (QSV_TIME_LOW, QSV_TIME_LOW, &start, sizeof (start));
      if (DosSleep (1000 * sec) == 0)
        {
          FS_RESTORE();
          return 0;
        }
      DosQuerySysInfo (QSV_TIME_LOW, QSV_TIME_LOW, &stop, sizeof (stop));
      FS_RESTORE();
      elapsed = stop - start;
      if (sec < elapsed)
        return 0;
      return sec - elapsed;
    }
}
