/* sys/remove.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes
                          -- Copyright (c) 2003 by Knut St. Osmundsen */

#include "libc-alias.h"
#define INCL_FSMACROS
#define INCL_DOSMISC
#include <os2safe.h>
#include <os2emx.h>
#include <stdio.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int _STD(remove)(const char *name)
{
    static int    fUseForce; /* state: 0 - uninit, 1 - DosForceDelete, -1 - DosDelete */
    ULONG         rc;
    FS_VAR();

    FS_SAVE_LOAD();
    /*
     * DosDelete is kind of slow as it always scans the environment (in a R0
     * accessing R3 data safe manner to make matters worse even) for DELDIR.
     * Since only a limited number of programs actually changes this
     * environment block, we assume that it's ok to check the first time if
     * DELDIR processing is enabled or not. If it isn't there, we can use
     * DosForceDelete and save quite a bit of time if we're called some
     * times.
     */
    if (fUseForce == 0)
    {
        PSZ psz = NULL;
        if (DosScanEnv("DELDIR", &psz) || !psz)
            fUseForce = 1;
        else
            fUseForce = -1;
    }

    /*
     * Do the delete.
     */
    if (fUseForce == 1)
        rc = DosForceDelete(name);
    else
        rc = DosDelete(name);
    FS_RESTORE();
    if (rc)
    {
        _sys_set_errno(rc);
        return -1;
    }
    return 0;
}
