/* sys/execname.c (emx+gcc) -- Copyright (c) 1993-1996 by Eberhard Mattes */

#include "libc-alias.h"
#define INCL_DOS
#define INCL_FSMACROS
#include <os2emx.h>
#include <stdlib.h>
#include <string.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int _execname (char *dst, size_t size)
{
  ULONG rc;
  PTIB ptib;
  PPIB ppib;
  FS_VAR();

  if (size == 0)
    return -1;

  FS_SAVE_LOAD();
  rc = DosGetInfoBlocks (&ptib, &ppib);
  if (rc != 0)
    {
      FS_RESTORE();
      *dst = 0;
      return -1;
    }

  rc = DosQueryModuleName (ppib->pib_hmte, size, dst);
  FS_RESTORE();
  if (rc != 0)
    {
      *dst = 0;
      return -1;
    }
  return 0;
}
