/* sys/open.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes
   Copyright (c) 2003 Dimitry Froloff
   Copyright (c) 2003 knut st. osmundsen
 */

#include "libc-alias.h"
#define INCL_DOSERRORS
#define INCL_FSMACROS
#include <os2emx.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <emx/syscalls.h>
#include <alloca.h>
#include "syscalls.h"

int __open(const char *pszFile, int flags, off_t cbInitial)
{
    ULONG   rc;
    ULONG   flOpenMode;
    ULONG   flOpenFlags;
    ULONG   flAttr;
    ULONG   ulAction;
    HFILE   hFile;
    int     failed_open_errno;
    FS_VAR();

    /*
     * Interpret "/dev/null" as the pszFile of the null device "NUL".
     * Interpret "/dev/tty" as the pszFile of the console device "CON".
     */
    if (!strcmp(pszFile, "/dev/null"))
        pszFile = "nul";
    else if (!strcmp(pszFile, "/dev/tty"))
        pszFile = "con";

    /*
     * Extract the access mode and sharing mode bits.
     */
    flOpenMode = flags & 0x77;

    /*
     * File O_NOINHERIT and O_SYNC.
     */
    if (flags & _SO_NOINHERIT)
        flOpenMode |= OPEN_FLAGS_NOINHERIT;
    if (flags & _SO_SYNC)
        flOpenMode |= OPEN_FLAGS_WRITE_THROUGH;

    /*
     * Extract the file flAttribute bits.
     */
    flAttr = (flags >> 8) & 0xff;
    if (_sys_umask & 0200)
        flAttr |= FILE_READONLY;

    /*
     * Translate ERROR_OPEN_FAILED to ENOENT unless O_EXCL is set (see below).
     */
    failed_open_errno = ENOENT;

    /*
     * Compute `flOpenFlags' depending on `flags'.  Note that _SO_CREAT is
     * set for O_CREAT.
     */
    if (flags & _SO_CREAT)
    {
        if (flags & _SO_EXCL)
        {
            flOpenFlags = OPEN_ACTION_FAIL_IF_EXISTS | OPEN_ACTION_CREATE_IF_NEW;
            failed_open_errno = EEXIST;
        }
        else if (flags & _SO_TRUNC)
            flOpenFlags = OPEN_ACTION_REPLACE_IF_EXISTS | OPEN_ACTION_CREATE_IF_NEW;
        else
            flOpenFlags = OPEN_ACTION_OPEN_IF_EXISTS | OPEN_ACTION_CREATE_IF_NEW;
    }
    else if (flags & _SO_TRUNC)
        flOpenFlags = OPEN_ACTION_REPLACE_IF_EXISTS | OPEN_ACTION_FAIL_IF_NEW;
    else
        flOpenFlags = OPEN_ACTION_OPEN_IF_EXISTS | OPEN_ACTION_FAIL_IF_NEW;

    if (!(flags & _SO_SIZE))
        cbInitial = 0;

    /*
     * Try to open the file.
     */
    FS_SAVE_LOAD();
#if OFF_MAX > LONG_MAX
    if (__pfnDosOpenL)
    {
        LONGLONG cbInitialTmp = cbInitial;
        int     cch = strlen(pszFile);
        char *  pszFile_safe = alloca(cch + 1);
        if (pszFile_safe)
        {
            strcpy(pszFile_safe, pszFile);
            rc = __pfnDosOpenL(pszFile_safe, &hFile, &ulAction, cbInitialTmp, flAttr, flOpenFlags, flOpenMode, NULL);
        }
        else
            rc = ERROR_NOT_ENOUGH_MEMORY;
    }
    else
    {
        ULONG cbInitialTmp = (ULONG)cbInitial;
        if (cbInitial > LONG_MAX)
        {
            FS_RESTORE();
            errno = EOVERFLOW;
            return -1;
        }
        rc = DosOpen(pszFile, &hFile, &ulAction, cbInitialTmp, flAttr, flOpenFlags, flOpenMode, NULL);
    }
#else
    {
        ULONG cbInitialTmp = cbInitial;
        rc = DosOpen(pszFile, &hFile, &ulAction, cbInitialTmp, flAttr, flOpenFlags, flOpenMode, NULL);
    }
#endif
    FS_RESTORE();

    /*
     * Handle any errors.
     */
    if (rc)
    {
        if (rc == ERROR_OPEN_FAILED)
            errno = failed_open_errno;
        else
            _sys_set_errno(rc);
        return -1;
    }
    return hFile;
}
