/* sys/newthrea.c (emx+gcc) -- Copyright (c) 1993-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <os2emx.h>
#include <errno.h>
#include <emx/syscalls.h>
#include <emx/umalloc.h>
#include "syscalls.h"
int __sys_newthread (int tid, int *errnop); /* used in sys/386/systhrea.s */


int __sys_newthread (int tid, int *errnop)
{
  void *data;

  if (tid >= MAX_THREADS)
    {
      if (errnop != NULL)
        *errnop = EAGAIN;
      return -1;
    }
  data = _hmalloc (sizeof (thread_data));
  if (!data)
    {
      errno = ENOMEM;
      return -1;
    }
  _sys_thread_table[tid] = data;
  _sys_init_thread (data);
  return 0;
}


int __newthread (int tid)
{
  return __sys_newthread (tid, &errno);
}
