/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Standard XPG basename() implementation.
    Returns a pointer to the last component of a pathname.
    If pathname ends with a slash, it is removed.
    If pathname is NULL or empty, "." is returned.
    If pathname consist only of slashes, "/" is returned.
*/

#include "libc-alias.h"
#include <libgen.h>
#include <string.h>
#include <ctype.h>

char *_STD(basename) (char *pathname); /* header is messing with the name redefinition. */

char *_STD(basename) (char *pathname)
{
  char *x;
  char *oldpath = pathname;

  if (!pathname || !*pathname)
    return ".";

  /* Skip drive specifier, if any */
  if (isalpha (pathname [0]) && (pathname [1] == ':'))
    pathname += 2;

  x = strchr (pathname, 0);
  /* Remove all trailing slashes */
  while ((x [-1] == '/' || x [-1] == '\\') && (x > pathname))
    *--x = 0;
  if (x == pathname)
  {
    /* If pathname contains a drive letter, returns DRIVE:/, not just "/" */
    if (oldpath != pathname)
    {
      *x++ = '/';
      *x = 0;
      return oldpath;
    }
    return "/";
  }

  while ((x > pathname) && (x [-1] != '/') && (x [-1] != '\\'))
    x--;

  return x;
}
