/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Convert the zero-terminated sequence of wchar_t codes at pwcs to a
    multibyte character sequence beginning at s. The multibyte character
    sequence starts in the initial shift state. At most n bytes are stored.
    s will be terminated with a null character if n is big enough.

    The shift state of wctomb() is not affected.

    wcstombs() returns the number of bytes stored to s (excluding the
    terminating null character) or (size_t_t)-1 if a code could not be
    counverted.

    Affected by LC_CTYPE locale setting.

    BUGS: Currently shift states between calls to multibyte/widechar
    functions are lost.
*/

#define INCL_FSMACROS
#include <os2emx.h>
#define __INTERNAL_DEFS
#include "libc-alias.h"
#include <sys/locale.h>
#include <string.h>
#include <stdlib.h>

size_t _STD(wcstombs) (char *s, const wchar_t *pwcs, size_t n)
{
  size_t nonid, sl = UniStrlen (pwcs) + 1, nw = n;
  int rc;
  FS_VAR();

  FS_SAVE_LOAD();
  rc = UniUconvFromUcs (__locale_ctype.uconv, (UniChar **)&pwcs, &sl, (void *)&s, &nw, &nonid);
  FS_RESTORE();
  if (rc)
    return -1;

  return n - nw - 1;
}
