/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Convert the multibyte character pointed to by s to a wchar_t code and
    store it to pwc. If s is NULL, the shift state is reset to the initial
    state. At most n bytes at s are examined; a multibyte character consisting
    of more than n bytes is deemed invalid.

    The shift state of mblen() is not affected.

    If s is NULL, mbtowc() returns a non-zero value (if state-dependent
    encoding is used) or a zero value (if state-dependent encoding is not used).
    If s is not NULL, mbtowc() returns 0 (if s points to the null character),
    the number of bytes comprising the multibyte character pointed to by s
    (if there is a valid multibyte character), or -1 (if there is not a valid
    multibyte character).

    Affected by LC_CTYPE locale setting.

    BUGS: Currently shift states between calls to multibyte/widechar
    functions are lost.
*/

#define INCL_FSMACROS
#include <os2emx.h>
#define __INTERNAL_DEFS
#include "libc-alias.h"
#include <sys/locale.h>
#include <string.h>
#include <stdlib.h>

int _STD(mbtowc) (wchar_t *pwc, const char *s, size_t n)
{
  size_t nonid, ni = n, no = 1;
  int rc;
  FS_VAR();

  if (!s)
    return 0;               /* No state dependency */

  FS_SAVE_LOAD();
  rc = UniUconvToUcs (__locale_ctype.uconv, (void *)&s, &ni, &pwc, &no, &nonid);
  FS_RESTORE();

  if ((rc == 0) || (rc == UCONV_E2BIG))
    return n - ni;

  return -1;
}
