/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Compute the number of bytes comprising the multibyte character pointed
    to by s. If s is NULL, the shift state is reset to the initial state.
    At most n bytes at s are examined; a multibyte character consisting of
    more than n bytes is deemed invalid.

    If s is NULL, mblen() returns a non-zero value (if state-dependent encoding
    is used) or a zero value (if state-dependent encoding is not used).
    If s is not NULL, mblen() returns 0 (if s points to the null character),
    the number of bytes comprising the multibyte character pointed to by s
    (if there is a valid multibyte character), or -1 (if there is not a valid
    multibyte character).

    Affected by LC_CTYPE locale setting.

    BUGS: Currently shift states between calls to multibyte/widechar
    functions are lost.
*/

#define __INTERNAL_DEFS
#include "libc-alias.h"
#include <stdlib.h>
#include <sys/locale.h>

int _STD(mblen) (const char *s, size_t n)
{
  int pl;
  if (!n)
    return -1;
  CHK_MBCS_PREFIX (__locale_ctype, *s, pl);
  return pl ? pl : -1;
}
