/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Helper function: Convert a character from Unicode.
    Returns number of bytes in the MBCS character.
*/

#define INCL_FSMACROS
#include <os2emx.h>
#include <uconv.h>
#include <emx/locale.h>

int __from_ucs (UconvObject uconv_obj, UniChar c, unsigned char *sbcs,
  size_t len)
{
  UniChar *inbuf = &c;
  void *outbuf = sbcs;
  size_t nonid, in_left = 1, out_left = len;
  int rc;
  FS_VAR();

  FS_SAVE_LOAD();
  rc = UniUconvFromUcs (uconv_obj, &inbuf, &in_left, &outbuf, &out_left, &nonid);
  FS_RESTORE();
  if (rc || nonid || in_left)
    return 0;

  return len - out_left;
}
