/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Convert an ASCIIZ codepage to UCS-2 form and convert POSIX codepage
    names to names understood by OS/2 Unicode API.
*/

#include <string.h>
#include <uconv.h>
#include <emx/locale.h>

/* Convert an encoding name to te form understood by UniCreateUconvObject.  */
void __convert_codepage (const char *cp, UniChar *ucp)
{
  size_t sl = 0;

  if (!stricmp (cp, "EUC-JP"))
    memcpy (ucp, L"IBM-954", 8*2);
  else if (!stricmp (cp, "EUC-KR"))
    memcpy (ucp, L"IBM-970", 8*2);
  else if (!stricmp (cp, "EUC-TW"))
    memcpy (ucp, L"IBM-964", 8*2);
  else if (!stricmp (cp, "EUC-CN"))
    memcpy (ucp, L"IBM-1383", 9*2);
  else if (!stricmp (cp, "BIG5"))
    memcpy (ucp, L"IBM-950", 8*2);
  else
    {
      /* Transform CPXXX naming style to IBM-XXX style */
      if ((cp[0] == 'C' || cp[0] == 'c') && (cp[1] == 'P' || cp[1] == 'p'))
        {
          ucp[sl++] = 'I';
          ucp[sl++] = 'B';
          ucp[sl++] = 'M';
          ucp[sl++] = '-';
          cp += 2;
        }

      while (*cp != '\0')
        ucp[sl++] = *cp++;
      ucp[sl] = 0;
    }
}
