/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Compare at most 'len' characters from two zero-terminated strings
    case-insensitively.
*/

#define INCL_FSMACROS
#include <os2emx.h>
#define __INTERNAL_DEFS
#include "libc-alias.h"
#include <stddef.h>
#include <sys/locale.h>
#include <string.h>

int _STD(strnicmp) (__const__ char *s1, __const__ char *s2, size_t len)
{
  unsigned char c1;
  unsigned char c2;

  if (!len)
    return 0;

  c1 = *s1; c2 = *s2;

  if (__locale_ctype.mbcs)
  {
    FS_VAR();
    FS_SAVE_LOAD();
    /* MBCS case. One additional memory lookup per character. */
    for (;;)
    {
      int d;

      if (IS_MBCS_PREFIX (__locale_ctype, c1)
       || IS_MBCS_PREFIX (__locale_ctype, c2))
      {
        /* Translate unknown characters to Unicode, and compare them...
           We perhaps should convert them back to MBCS, but anyway it is
           not defined how memicmp should work on multi-byte characters... */
        UniChar uc1, uc2;
        int c1l, c2l;
        if (!(c1l = __to_ucs (__locale_ctype.uconv, s1, len, &uc1)))
          uc1 = c1, c1l = 1;
        else
          uc1 = UniTransLower (__locale_ctype.locale, uc1);
        if (!(c2l = __to_ucs (__locale_ctype.uconv, s2, len, &uc2)))
          uc2 = c2, c2l = 1;
        else
          uc2 = UniTransLower (__locale_ctype.locale, uc2);
        d = uc1 - uc2;
        c1l--; c2l--;
        s1 += c1l; s2 += c2l;
        len -= c1l;
      }
      else
        d = __locale_ctype.locase [c1] - __locale_ctype.locase [c2];
      if (d || !c1 || !c2)
      {
        FS_RESTORE();
        return d;
      }
      if (!--len)
      {
        FS_RESTORE();
        return 0;
      }
      c1 = *++s1;
      c2 = *++s2;
    } /* endfor */
    FS_RESTORE();
  }
  else
    /* SBCS case (faster). */
    for (;;)
    {
      int d = __locale_ctype.locase [c1] - __locale_ctype.locase [c2];
      if (d || !c1 || !c2)
        return d;
      if (!--len)
        return 0;
      c1 = *++s1;
      c2 = *++s2;
    } /* endfor */

  /* This point never reached */
}
