/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Lowercase an ASCIIZ string.
*/

#define INCL_FSMACROS
#include <os2emx.h>
#define __INTERNAL_DEFS
#include "libc-alias.h"
#include <sys/locale.h>
#include <string.h>

static int __uni_strlwr (UniChar *ucs, void *arg)
{
  UniChar *c;
  (void)arg;
  for (c = ucs; *c; c++)
    *c = UniTransLower (__locale_ctype.locale, *c);
  return 1;
}

char *_STD(strlwr) (char *string)
{
  unsigned char c;
  unsigned char *s = (unsigned char *)string;

  if (__locale_ctype.mbcs)
  {
    while ((c = *s))
    {
      if (IS_MBCS_PREFIX (__locale_ctype, c))
      {
        /* Allright, we encountered a MBCS character. Convert everything
           until the end to Unicode, do the work in Unicode and then
           convert back to MBCS. */
        FS_VAR();
        FS_SAVE_LOAD();
        __do_Unicode (__locale_ctype.uconv, s, s, __uni_strlwr);
        FS_RESTORE();
        break;
      }
      *s++ = __locale_ctype.locase [c];
    }
  }
  else
    while ((c = *s))
      *s++ = __locale_ctype.locase [c];

  return string;
}
