/* $Id: unsetenv.c 789 2003-10-02 01:16:45Z bird $ */
/** @file
 *
 * unsetenv()
 *
 * Copyright (c) 2003 InnoTek Systemberatung GmbH
 * Author: knut st. osmundsen <bird-srcspam@anduin.net>
 *
 * All Rights Reserved
 *
 */


#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <emx/startup.h>



/**
 * Delete environment variable.
 *
 * @returns 0 on success.
 * @returns -1 and errno=EINVAL if name is invalid in any way.
 * @param   name    Name of environment variable to unset.
 *                  Shall not be NULL, empty string of contain '='.
 * @remark  May be leaking memory, but that's what BSD does.
 * @author  knut st. osmundsen <bird-srcspam@anduin.net>
 */
int _STD(unsetenv)(const char *name)
{
    int     lenname;
    char ** p;

    /* validate input */
    if (name == NULL || *name == '\0' || strchr(name, '=') != NULL)
      {
        errno = EINVAL;
        return -1;
      }


    /* search (thru all the environment in case of multiple defintions). */
    lenname = strlen(name);
    p = environ;
    while (*p != NULL)
      {
        char *s = *p;
        if (strncmp (s, name, lenname) == 0 && (s[lenname] == 0 || s[lenname] == '='))
          { /* shift down the remaining entries. */
            char **p2 = p;
            for (;;p2++)
                if ((p2[0] = p2[1]) == NULL)
                    break;
          }
        else
          {
            /* next */
            p++;
          }
      }
    return 0;
}
