/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Utility routine that converts a string to Unicode, calls some
    function and then converts the string back. Used to handle
    MBCS encodings.
*/

#define INCL_FSMACROS
#include <os2emx.h>
#include <uconv.h>
#include <alloca.h>
#include <malloc.h>
#include <string.h>

void __do_Unicode (UconvObject *uconv, char *s, void *arg,
  int (*xform) (UniChar *, void *))
{
  /* We'll get maximum that much UniChar's */
  size_t sl = strlen (s) + 1;
  char free_ucs = 0;
  UniChar *ucs;
  void *mbcsbuf;
  UniChar *ucsbuf;
  size_t in_left, out_left, nonid;
  FS_VAR();
  FS_SAVE_LOAD();

  /* Allocate strings up to 2000 characters on the stack */
  if (sl < 4096 / sizeof (UniChar))
    ucs = alloca (sl * sizeof (UniChar));
  else
  {
    free_ucs = 1;
    ucs = malloc (sl * sizeof (UniChar));
  }

  /* Translate the string to Unicode */
  mbcsbuf = s; in_left = sl;
  ucsbuf = ucs; out_left = sl;
  if (UniUconvToUcs (uconv, &mbcsbuf, &in_left, &ucsbuf, &out_left, &nonid))
    goto out;

  /* Apply the transform function */
  if (xform (ucs, arg))
  {
    /* Now convert back to MBCS */
    ucsbuf = ucs; in_left = sl - out_left;
    mbcsbuf = s; out_left = sl;
    UniUconvFromUcs (uconv, &ucsbuf, &in_left, &mbcsbuf, &out_left, &nonid);
  }

out:
  if (free_ucs)
    free (ucs);
  FS_RESTORE();
}
