/* sys/kill.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#define INCL_DOSEXCEPTIONS
#define INCL_FSMACROS
#include <os2emx.h>
#include <errno.h>
#include <signal.h>
#include <sys/process.h>
#include "syscalls.h"

int _STD(kill) (int pid, int sig)
{
  ULONG rc;
  ULONG n;
  FS_VAR();

  if (pid == getpid ())
    {
      if (sig == 0)
        return 0;
      return raise (sig);
    }
  else if (sig == SIGINT || sig == SIGBREAK)
    {
      if (sig == SIGINT)
        n = XCPT_SIGNAL_INTR;
      else
        n = XCPT_SIGNAL_BREAK;
      FS_SAVE_LOAD();
      rc = DosSendSignalException (pid, n);
      FS_RESTORE();
      if (rc != 0)
        {
          _sys_set_errno (rc);
          return -1;
        }
      return 0;
    }
  errno = EINVAL;
  return -1;
}
