/* sys/ioctl1.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <errno.h>
#define INCL_FSMACROS
#include <os2emx.h>
#include <emx/syscalls.h>
#include "syscalls.h"


int __ioctl1 (int handle, int code)
{
  ULONG rc;
  ULONG htype, hflags;
  FS_VAR();

  if (code != 0)
    {
      errno = EINVAL;
      return -1;
    }
  FS_SAVE_LOAD();
  rc = DosQueryHType (handle, &htype, &hflags);
  FS_RESTORE();
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return -1;
    }
  if ((htype & 0xff) == 0)
    return 0;
  return (hflags & 0x0f) | 0x80;
}
