/* sys/ftruncat.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes
   Copyright (c) 2003 Dimitry Froloff
   Copyright (c) 2003 knut st. osmundsen
 */

#include "libc-alias.h"
#define INCL_FSMACROS
#include <os2emx.h>
#include <emx/syscalls.h>
#include <limits.h>
#include <errno.h>
#include "syscalls.h"

int __ftruncate(int hFile, off_t cbFile)
{
    ULONG       rc;
    off_t       cbCur;
    union
    {
        FILESTATUS3     fsts3;
        FILESTATUS3L    fsts3L;
    } info;
    FS_VAR();

    /*
     * First step, figure out the current size.
     */
    FS_SAVE_LOAD();
#if OFF_MAX > LONG_MAX
    if (__pfnDosOpenL)
    {
        rc = DosQueryFileInfo(hFile, FIL_STANDARDL, &info, sizeof(info.fsts3L));
        cbCur = info.fsts3L.cbFile;
    }
    else
#endif
    {
        rc = DosQueryFileInfo(hFile, FIL_STANDARD, &info, sizeof(info.fsts3));
        cbCur = info.fsts3.cbFile;
    }
    FS_RESTORE();
    if (rc)
    {
        _sys_set_errno(rc);
        return -1;
    }


    /*
     * Is the file larger than the truncation size?
     * Then set the desired file size.
     */
    if (cbCur > cbFile)
    {
        FS_SAVE_LOAD();
#if OFF_MAX > LONG_MAX
        if (__pfnDosSetFileSizeL)
            rc = __pfnDosSetFileSizeL(hFile, cbFile);
        else
        {
            if (cbFile > __LONG_MAX)
            {
                FS_RESTORE();
                errno = EOVERFLOW;
                return -1;
            }
            rc = DosSetFileSize(hFile, cbFile);
        }
#else
        rc = DosSetFileSize(hFile, cbFile);
#endif
        FS_RESTORE();
        if (rc != 0)
        {
            _sys_set_errno(rc);
            return -1;
        }
    }
    return 0;
}
