/* sys/dup2.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#define INCL_FSMACROS
#include <os2emx.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __dup2 (int handle1, int handle2)
{
  ULONG rc, state;
  HFILE hNew;
  FS_VAR();

  hNew = handle2;
  FS_SAVE_LOAD();
  if (handle1 == handle2)
    rc = DosQueryFHState (handle1, &state); /* Check HANDLE */
  else
    rc = DosDupHandle (handle1, &hNew);
  FS_RESTORE();
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return -1;
    }
  return hNew;
}
