/* sys/chsize.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes
   Copyright (c) 2003 Dimitry Froloff
   Copyright (c) 2003 knut st. osmundsen
 */

#include "libc-alias.h"
#define INCL_FSMACROS
#include <os2emx.h>
#include <emx/syscalls.h>
#include <limits.h>
#include <errno.h>
#include "syscalls.h"


int __chsize (int hFile, __off_t cbFile)
{
    ULONG rc;
    FS_VAR();

    FS_SAVE_LOAD();
#if OFF_MAX > LONG_MAX
    if (__pfnDosSetFileSizeL)
        rc = __pfnDosSetFileSizeL(hFile, cbFile);
    else
    {
        if (cbFile > LONG_MAX)
        {
            errno = EOVERFLOW;
            return -1;
        }
        rc = DosSetFileSize(hFile, cbFile);
    }
#else
    rc = DosSetFileSize(hFile, cbFile);
#endif
    FS_RESTORE();

    if (rc)
    {
        _sys_set_errno(rc);
        return -1;
    }
    return 0;
}
