/* sys/rename.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#define INCL_FSMACROS
#include <os2emx.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int _STD(rename) (const char *old_name, const char *new_name)
{
  ULONG rc;
  FS_VAR();

  FS_SAVE_LOAD();
  rc = DosMove (old_name, new_name);
  FS_RESTORE();
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return -1;
    }
  return 0;
}
