/* sys/mkdir.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#define INCL_FSMACROS
#include <os2emx.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __mkdir (const char *name)
{
  ULONG rc;
  FS_VAR();

  FS_SAVE_LOAD();
  rc = DosCreateDir (name, NULL);
  FS_RESTORE();
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return -1;
    }
  return 0;
}
