/* sys/lseek.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes
   Copyright (c) 2003 Dimitry Froloff
   Copyright (c) 2003 knut st. osmundsen
 */

#include "libc-alias.h"
#define INCL_FSMACROS
#include <os2emx.h>
#include <emx/syscalls.h>
#include <limits.h>
#include <errno.h>
#include "syscalls.h"

off_t __lseek(int hFile, off_t off, int origin)
{
    ULONG   rc;
    off_t   cbNew;
    FS_VAR();

    if (origin == FILE_SECTOR)
    {
        errno = EINVAL;
        return -1;
    }

    FS_SAVE_LOAD();
#if OFF_MAX > LONG_MAX
    if (__pfnDosSetFilePtrL)
    {
        LONGLONG cbNewTmp;
        rc = __pfnDosSetFilePtrL(hFile, off, origin, &cbNewTmp);
        cbNew = cbNewTmp;
    }
    else
    {
        ULONG cbNewTmp;
        if (off > LONG_MAX || off < LONG_MIN)
        {
            FS_RESTORE();
            errno = EOVERFLOW;
            return -1;
        }
        rc = DosSetFilePtr(hFile, off, origin, &cbNewTmp);
        cbNew = cbNewTmp;
    }
#else
    {
        ULONG cbNewTmp;
        rc = DosSetFilePtr(hFile, off, origin, &cbNewTmp);
        cbNew = cbNewTmp;
    }
#endif
    FS_RESTORE();

    if (rc)
    {
        _sys_set_errno (rc);
        return -1;
    }

    return cbNew;
}

