/* sys/endthrea.c (emx+gcc) -- Copyright (c) 1993-1996 by Eberhard Mattes */

#include "libc-alias.h"
#define INCL_DOS
#define INCL_FSMACROS
#include <os2emx.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __endthread (int tid)
{
  thread_data *tp;
  FS_VAR();

  if (tid < MAX_THREADS && _sys_thread_table[tid] != NULL)
    {
      tp = _sys_thread_table[tid];
      FS_SAVE_LOAD();
      if (tp->fd.hdir != HDIR_CREATE)
        {
          DosFindClose (tp->fd.hdir);
          tp->fd.hdir = HDIR_CREATE;
        }
      DosSubFreeMem (_sys_private_heap, tp, sizeof (thread_data));
      FS_RESTORE();
      _sys_thread_table[tid] = NULL;
    }
  return 0;
}
