/* sys/fstat.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes
   sys/__fstat.c (libc)  -- Copyright (c) 2003 by knut st. osmundsen
 */

#include "libc-alias.h"
#include <os2emx.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <emx/syscalls.h>
#include "syscalls.h"

int __fstat(int hFile, struct stat *pStat)
{
    ULONG rc;
    ULONG ulType;
    ULONG flFlags;

    /*
     * Use query handle type to figure out the file type.
     */
    memset(pStat, 0, sizeof(*pStat));
    rc = DosQueryHType(hFile, &ulType, &flFlags);
    if (rc)
    {
        _sys_set_errno(rc);
        return -1;
    }
    switch (ulType & 0xff)
    {
        case FHT_CHRDEV:
            pStat->st_mode = S_IFCHR;
            break;
        case FHT_PIPE:
            pStat->st_mode = S_IFSOCK;
            break;
        default:
            pStat->st_mode = S_IFREG;
            break;
    }

    if (pStat->st_mode == S_IFREG)
    {
        union
        {
            FILESTATUS3     fsts3;
            FILESTATUS3L    fsts3L;
        } info;
    #if OFF_MAX > LONG_MAX
        int     fLarge = 0;
    #endif

        /*
         * Get file info.
         */
#if OFF_MAX > LONG_MAX
        if (__pfnDosOpenL)
        {
            rc = DosQueryFileInfo(hFile, FIL_STANDARDL, &info, sizeof(info.fsts3L));
            fLarge = 1;
        }
        else
#endif
            rc = DosQueryFileInfo(hFile, FIL_STANDARD, &info, sizeof(info.fsts3));
        if (rc)
        {
            _sys_set_errno (rc);
            return -1;
        }

        /*
         * Format stats struct.
         *      We know the info struct layouts!
         *      Only cbFile, cbFileAlloc and attrFile need be accessed
         *      using the specific structure.
         */
        /* Times: FAT might not return create and access time. */
        pStat->st_mtime = _sys_p2t(info.fsts3.ftimeLastWrite, info.fsts3.fdateLastWrite);
        if (    FTIMEZEROP(info.fsts3.ftimeCreation)
            &&  FDATEZEROP(info.fsts3.fdateCreation))
            pStat->st_ctime = pStat->st_mtime;
        else
            pStat->st_ctime = _sys_p2t(info.fsts3.ftimeCreation, info.fsts3.fdateCreation);
        if (    FTIMEZEROP(info.fsts3.ftimeLastAccess)
            &&  FDATEZEROP(info.fsts3.fdateLastAccess))
            pStat->st_atime = pStat->st_mtime;
        else
            pStat->st_atime = _sys_p2t(info.fsts3.ftimeLastAccess, info.fsts3.fdateLastAccess);

#if OFF_MAX > LONG_MAX
        if (fLarge)
        {
            pStat->st_size = info.fsts3L.cbFile;
            pStat->st_blocks = info.fsts3L.cbFileAlloc / S_BLKSIZE;
            rc = info.fsts3L.attrFile;
        }
        else
#endif
        {
            pStat->st_size = info.fsts3.cbFile;
            pStat->st_blocks = info.fsts3.cbFileAlloc / S_BLKSIZE;
            rc = info.fsts3.attrFile;
        }
        pStat->st_attr = rc;
        if (rc & FILE_READONLY)
            pStat->st_mode |= (S_IREAD >> 6) * 0111;
        else
            pStat->st_mode |= ((S_IREAD|S_IWRITE) >> 6) * 0111;
    }
    else
    {
        pStat->st_size = 0;
        rc = DosQueryFHState(hFile, &flFlags);
        if (rc)
        {
            _sys_set_errno (rc);
            return -1;
        }
        if ((flFlags & 7) == OPEN_ACCESS_READONLY)
            pStat->st_mode |= (S_IREAD >> 6) * 0111;
        else
            pStat->st_mode |= ((S_IREAD|S_IWRITE) >> 6) * 0111;
    }

    /* default fake stuff */
    pStat->st_uid = 0;
    pStat->st_gid = 0;
    pStat->st_ino = _sys_ino++;
    if (_sys_ino == 0)
        _sys_ino = 1;
    pStat->st_dev = 0;
    pStat->st_rdev = 0;
    pStat->st_nlink = 1;
    pStat->st_blksize = 4096*48;
    return 0;
}
