/*
    Dynamic library low-level initialization routine.

    Copyright (c) 1992-1998 by Eberhard Mattes
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    This routine is called from dll0.o. It should perform
    all kinds of low-level initialization required by a DLL.
*/

#include "libc-alias.h"
#define INCL_DOS
#include <os2emx.h>
#include <string.h>
#include <sys/builtin.h>
#include <sys/fmutex.h>
#include <emx/startup.h>
#include <emx/syscalls.h>
#include <alloca.h>

#include "syscalls.h"

#define SYS_PRIVATE_HEAP_SIZE 0x100000

extern int __init_environ(const char *pszEnv);
extern unsigned char _osminor;
extern unsigned char _osmajor;

/**
 * Common init code for crt0 and dll0.
 * This should perhaps be a part of _CRT_init.
 */
int __init_dll(void)
{
    ULONG   aul[2];
    ULONG   rc;
    PTIB    ptib;
    PPIB    ppib;
    int     n;
    static int initialized = 0;

    /*
     * Only called once.
     */
    if (initialized)
        return 0;
    initialized = 1;

    /*
     * Initialize _osmajor and _osminor.
     */
    DosQuerySysInfo(QSV_VERSION_MAJOR, QSV_VERSION_MINOR, &aul[0], sizeof(aul));
    _osminor = (unsigned char)aul[1];
    _osmajor = (unsigned char)aul[0];

    /*
     * Check for high memory (>512MB) support.
     */
    _sys_virtual_address_limit = 0;
    if (    !DosQuerySysInfo(QSV_VIRTUALADDRESSLIMIT, QSV_VIRTUALADDRESSLIMIT, &aul[0], sizeof(aul[0]))
        &&  aul[0] > 512)
        _sys_virtual_address_limit = aul[0] * 1024*1024;

    /*
     * Get the process ID and parent process ID.
     * This is also required for (stand-alone) DLLs. At least, we need ptib
     * and ppib.
     */
    /** @todo This must be replaced by the fast info block code from Odin/kLib. */
    rc = DosGetInfoBlocks(&ptib, &ppib);
    if (rc != 0)
        return -1;
    _sys_pid = ppib->pib_ulpid;
    _sys_ppid = ppib->pib_ulppid;

    /*
     * Initialize the heap.  Here, we only create the semaphore
     * (while having only one thread).  The heap will be created by __sbrk().
     */
    if (_fmutex_create(&_sys_heap_fmutex, 0) != 0)
        return -1;

    /*
     * LIBC Private heap, used for org_environ and per thread data.
     * Let's try put it in high memory...
     */
    rc = DosAllocMem(&_sys_private_heap, SYS_PRIVATE_HEAP_SIZE,
                     _sys_virtual_address_limit
                        ? PAG_READ | PAG_WRITE | OBJ_ANY
                        : PAG_READ | PAG_WRITE);
    if (rc != 0)
        return -1;
    rc = DosSubSetMem(_sys_private_heap,
                      DOSSUB_INIT | DOSSUB_SPARSE_OBJ | DOSSUB_SERIALIZE,
                      SYS_PRIVATE_HEAP_SIZE);
    if (rc != 0)
        return -1;

    /*
     * Initialize thread table and entry for this thread.
     */
    /** @todo Remove this table, replace it with a pointer backed by TLS memory. */
    for (n = 0; n < MAX_THREADS; ++n)
        _sys_thread_table[n] = NULL;
    __newthread(ptib->tib_ptib2->tib2_ultid);

    /*
     * Setup environment (org_environ and _STD(environ))
     */
    rc = __init_environ(ppib->pib_pchenv);
    if (rc)
        return -1;

    /*
     * Get current time for clock() for use as process startup time.
     */
    _sys_get_clock(&_sys_clock0_ms);
    return 0;
}
