/* startup.c (emx+gcc) -- Copyright (c) 1990-1998 by Eberhard Mattes */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <emx/io.h>
#include <emx/syscalls.h>

/* See app/iodata.c. */

extern int _nfiles;
extern int _files[];
extern int _lookahead[];

extern int __crtinit1__;
extern void __ctordtorInit1 (int *ptr);

static void init_files (void);

/* Initialize the C run-time library.  This function is called from
   crt0.s. */
int _CRT_init (void)
{
  static int startup_flag;

  /* Protect against multiple calls (for instance, by _CRT_init() in a
     _DLL_InitTerm() and by the application program's startup code). */
  if (startup_flag)
    return 0;
  startup_flag = 1;

  /* Initialize the file handles. */
  init_files ();

  /* Initialize streams etc. if required. */
  __ctordtorInit1 (&__crtinit1__);

  /* ANSI X3.159-1989, 4.1.3: "The value of errno is zero at program
     startup..."

     The above code usually sets errno to EBADF, therefore we reset
     errno to zero before calling main(). */
  errno = 0;

  return 0;
}


/* Initialize the file handles. */

static void init_files (void)
{
  int i, ht, fl;

  for (i = 0; i < _nfiles; ++i)
    {
      _files[i] = 0;
      _lookahead[i] = -1;

      /* Get the handle type.  If this fails, the handle is not open. */

      if (i < _io_ninherit && __ioctl2 (i, FGETHTYPE, (int)&ht) == 0)
        {
          /* init_streams() depends on _files[] being non-zero for
             open file handles.  When omitting O_TEXT, don't forget to
             set another bit. */

          _files[i] |= O_TEXT;
          if (HT_ISDEV (ht))
            _files[i] |= F_DEV;
          if (ht == HT_UPIPE || ht == HT_NPIPE)
            {
              _files[i] |= F_PIPE;
              fl = __fcntl (i, F_GETFL, 0);
              if (fl >= 0)
                _files[i] |= fl & O_NDELAY;
            }
          switch (i)
            {
            case 0:
              _files[0] |= O_RDONLY;
              break;

            case 1:
            case 2:
              _files[i] |= O_WRONLY;
              break;

            default:
              /* All other handles can be read and written. */
              _files[i] |= O_RDWR;
              break;
            }
        }
    }
}



/** @page Startup
 *
 * Quick description of how we startup a process which modules uses LIBC.
 *
 * The load first loads the DLLs of the process, calling their _DLL_InitTerm
 * entrypoints in order of dependencies. If you're using dynamic LIBC this
 * will be initiated first of the LIBC-based modules.
 *
 * LIBCxy.DLL:
 *      - dll0.s gets control and calls __init_dll in sys/__initdll.c
 *          - __init_dll calls __init_os_version() to set _osminor,_osmajor globals.
 *          - __init_dll creates _sys_heap_fmutex.
 *          - __init_dll initiates _sys_pid and _sys_ppid globals.
 *          - __init_dll allocates and initiatlized the _sys_private_heap heap, which is
 *            operated by DosSubSetMem() and it's friends.
 *          - __init_dll then initializes _sys_thread_table and calls __newthread() in
 *            sys/__newthread.c to create the thread 1 entry.
 *          - __init_dll then intializes _sys_clock0_ms with the current MS count.
 *      - dll0.s calls _DLL_InitTerm in startup/dllinit.c.
 *          - _DLL_InitTerm calls _CRT_init() in startup/startup.c to initialize the CRT.
 *              - _CRT_init calls init_files() to initialize the file handle tables.
 *              - _CRT_init then call all the crt init functions in __crtinit1__.
 *          - _DLL_InitTerm calls __ctordtorInit() to initate any exception structures and
 *            construct static C++ objects.
 *      - dll0.s then returns to DOSCALL1.DLL and back to the kernel.
 *
 * Your.DLL:
 *      - dll0.s gets control and calls __init_dll() in sys/__initdll.c
 *          - __init_dll returns at once since already done during LIBCxy.DLL init.
 *      - dll0.s calls _DLL_InitTerm in startup/dllinit.c.
 *          - _DLL_InitTerm calls _CRT_init() in startup/startup.c to initialize the CRT.
 *              - _CRT_init return at once since already done during LIBCxy.DLL init.
 *          - _DLL_InitTerm calls __ctordtorInit() to initate any exception structures and
 *            construct static C++ objects in _this_ DLL.
 *      - dll0.s then returns to DOSCALL1.DLL and back to the kernel.
 *
 * Your.exe:
 *      - crt0.s gets control and calls ___init_app in sys/386/appinit.s which forwards
 *        the call to __init() in sys/__init.c.
 *          - __init() calls __init_dll() which returns at once because of LIBCxy.DLL init.
 *          - __init() parse the environment and commandline to figure out how much stack
 *            to use for their arrays and the argument copy.
 *          - __init() the allocates the stack space space, adding an exception handler struct.
 *          - __init() parse the environment and create the array using allocated stack space.
 *          - __init() parse the commandline creating both array and a copy using allocated
 *            stack space.
 *          - __init() installs the exception handler.
 *          - __init() set the signal focus.
 *          - __init() then 'returns' thru the hack called ___init_ret in sys/386/appinit.s
 *      - crt0.s now get control back with esp pointing to the array of env vars.
 *      - crt0.s sets environ and _org_environ.
 *      - crt0.s sets up the call frame for main() by skipping it's way thru the env and
 *        arg arrays.
 *      - crt0.s calls _CRT_init() in startup/startup.c to initialize the CRT which returns
 *        immediately since since already done during LIBCxy.DLL init.
 *      - crt0.s the calls main() with the three arguments setup earlier.
 *      - crt0.s then calls exit() with the return value of main().
 *          - exit() will call all the registered at_exit functions.
 *          - exit() will call DosExit with the exit code and terminate the process.
 */
