/* sys/ftime.c (emx+gcc) -- Copyright (c) 1992-1996 by Eberhard Mattes */

#include "libc-alias.h"
#include <os2emx.h>
#include <sys/timeb.h>
#include <time.h>
#include <emx/time.h>
#include <emx/syscalls.h>
#include <386/builtin.h>
#include "syscalls.h"

/* Return time in local format */
void __ftime (struct timeb *ptr)
{
  DATETIME now;
  struct tm tm;

  DosGetDateTime (&now);
  tm.tm_sec = now.seconds;
  tm.tm_min = now.minutes;
  tm.tm_hour = now.hours;
  tm.tm_mday = now.day;
  tm.tm_mon = now.month - 1;
  tm.tm_year = now.year - 1900;

  ptr->time = (time_t)_mktime (&tm);
  /* Apply timezone correction to get UTC time since we don't know what
     timezone DosGetDateTime uses and whether it honors the TZ variable.
     Then apply application's own timezone to get local time back. */
  if (now.timezone != -1)
    ptr->time = ptr->time - (long)now.timezone * 60 + _tzi.tz;
  ptr->millitm = now.hundredths * 10;
}
