/* emx/time.h (emx+gcc) */

#ifndef _EMX_TIME_H
#define _EMX_TIME_H

#if defined (__cplusplus)
extern "C" {
#endif

#define _YEARS          (2106 - 1970 + 1)
#define TIME_T_MAX      0xffffffffUL

#if !defined (_TIME_T)
#define _TIME_T
typedef unsigned long time_t;
#endif

struct tm;

/* Maximum length for time zone standard - "GMT", "CEST" etc. */
#define __MAX_TZ_STANDARD_LEN 15

struct _tzinfo
{
  char tzname[__MAX_TZ_STANDARD_LEN + 1];
  char dstzname[__MAX_TZ_STANDARD_LEN + 1];
  int tz, dst, shift;
  int sm, sw, sd, st;
  int em, ew, ed, et;
};

extern int _tzset_flag;
extern struct _tzinfo _tzi;

extern unsigned short const _year_day[_YEARS+1];
extern unsigned short const _month_day_leap[];
extern unsigned short const _month_day_non_leap[];


int _day (int, int, int);
int _gmt2loc (unsigned long *);
int _loc2gmt (unsigned long *, int);
struct tm *_gmtime (struct tm *, const time_t *);
struct tm *_localtime (struct tm *, const time_t *);
unsigned long _mktime (struct tm *);
void _compute_dst_table (void);


static __inline__ int _leap_year (unsigned y)
{
  return (y % 4 != 0 ? 0 : y % 100 != 0 ? 1 : y % 400 != 0 ? 0 : 1);
}


#if defined (__cplusplus)
}
#endif

#endif /* not _EMX_TIME_H */
