/* $Id: setenv.c 584 2003-08-11 18:11:02Z bird $ */
/** @file
 *
 * setenv()
 *
 * Copyright (c) 2003 InnoTek Systemberatung GmbH
 * Author: knut st. osmundsen <bird-srcspam@anduin.net>
 *
 * All Rights Reserved
 *
 */

#include "libc-alias.h"
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <emx/startup.h>
#include <emx/time.h>           /* _tzset_flag */

           
/**
 * 
 * @returns 0 on success.
 * @returns -1 on failure with errno set to either EINVAL or ENOMEM.
 * @param   envname     Name of environment variable to set.
 *                      Shall not be NULL, empty string or contain '='.
 * @param   envval      The value to set.     
 * @param   overwrite   If set any existing variable should be overwritten.
 *                      If clear return successfully without changing any 
 *                      existing variable.
 *                      If there is not existing variable it is added 
 *                      regardless of the state of this flag.
 * @author  knut st. osmundsen <bird-srcspam@anduin.net>
 * @remark  We skip the first equal in the environment value like BSD does.
 */
int _STD(setenv) (const char *envname, const char *envval, int overwrite)
{
  char **p;
  int   lenname;
  int   lenval;
  int   env_size;

  /* validate */
  if (envname == NULL || *envname == '\0' || strchr(envname, '=') != NULL)
    {
      errno = EINVAL;
      return -1;
    }
  _tzset_flag = 0;              /* Call tzset() */

  /* BSD Compatability. */
  if (*envval == '=')
      envval++;

  /* search for existing variable iinstance  */
  lenname = strlen (envname);        
  p = environ;
  env_size = 0;
  if (p != NULL)
    while (*p != NULL)
      {
        char *s = *p;
        if (strncmp (s, envname, lenname) == 0 && (s[lenname] == 0 || s[lenname] == '='))
          break;
        ++p; ++env_size;
      }

  /* found it? */
  lenval = strlen(envval);
  if (p != NULL && *p != NULL)
    {
      if (!overwrite)
        return 0;
      /* if the older is larger then overwrite it */
      if (strlen(*p + lenname + 1) >= lenval)
        {
           memcpy(*p + lenname + 1, envval, lenval + 1);
           return 0;
        }
    }
  else
    {
      /* new variable: reallocate the environment pointer block */
      if (environ == _org_environ)
        {
          p = malloc ((env_size+2) * sizeof (char *));
          if (p == NULL) 
              return -1;
          environ = p;
          if (env_size != 0)
            memcpy (environ, _org_environ, env_size * sizeof (char *));
        }
      else
        {
          p = realloc (environ, (env_size+2) * sizeof (char *));
          if (p == NULL) 
              return -1;
          environ = p;
        }

      /* Add to end. */
      p = &environ[env_size+0];
      environ[env_size+1] = NULL;
    }

  /* Allocate space for new variable and assign it. */
  *p = malloc(lenname + lenval + 2);
  if (*p)
    return -1;
  memcpy(*p, envname, lenname);
  (*p)[lenname] = '=';
  memcpy(*p + lenname + 1, envval, lenval + 1);
  return 0;
}

