/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Character type querying.
*/

#ifndef _CTYPE_H
#define _CTYPE_H

#if defined (__cplusplus)
extern "C" {
#endif

#include <sys/locale.h>

static inline int isalnum (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__UPPER|__LOWER|__DIGIT); }

static inline int isalpha (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__UPPER|__LOWER); }

static inline int iscntrl (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__CNTRL); }

static inline int isdigit (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__DIGIT); }

static inline int isgraph (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__PUNCT|__UPPER|__LOWER|__DIGIT); }

static inline int islower (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__LOWER); }

static inline int isprint (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__PRINT); }

static inline int ispunct (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__PUNCT); }

static inline int isspace (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__SPACE); }

static inline int isupper (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__UPPER); }

static inline int isxdigit (int _c)
{ return __locale_ctype.cflags [_c & 0xff] & (__XDIGIT); }

static inline int toupper (int _c)
{ return __locale_ctype.upcase [_c & 0xff]; }

static inline int tolower (int _c)
{ return __locale_ctype.locase [_c & 0xff]; }

#if !defined (__STRICT_ANSI__) && !defined (_POSIX_SOURCE)

#define isascii(c) (!((c) & 0x80))
#define toascii(c) ((c) & 0x7f)

#endif

#if defined (__cplusplus)
}
#endif

#endif /* not _CTYPE_H */
