/* ctype.h (emx+gcc) */

#ifndef _CTYPE_H
#define _CTYPE_H

#if defined (__cplusplus)
extern "C" {
#endif

extern unsigned char _ctype[];

#define _UPPER  0x01
#define _LOWER  0x02
#define _DIGIT  0x04
#define _XDIGIT 0x08
#define _CNTRL  0x10
#define _SPACE  0x20
#define _PUNCT  0x40
#define _PRINT  0x80

extern inline int isalnum (int _c)
  { return (_ctype+1)[_c] & (_UPPER|_LOWER|_DIGIT); }
extern inline int isalpha (int _c)
  { return (_ctype+1)[_c] & (_UPPER|_LOWER); }
extern inline int iscntrl (int _c)
  { return (_ctype+1)[_c] & (_CNTRL); }
extern inline int isdigit (int _c)
  { return (_ctype+1)[_c] & (_DIGIT); }
extern inline int isgraph (int _c)
  { return (_ctype+1)[_c] & (_PUNCT|_UPPER|_LOWER|_DIGIT); }
extern inline int islower (int _c)
  { return (_ctype+1)[_c] & (_LOWER); }
extern inline int isprint (int _c)
  { return (_ctype+1)[_c] & (_PRINT); }
extern inline int ispunct (int _c)
  { return (_ctype+1)[_c] & (_PUNCT); }
extern inline int isspace (int _c)
  { return (_ctype+1)[_c] & (_SPACE); }
extern inline int isupper (int _c)
  { return (_ctype+1)[_c] & (_UPPER); }
extern inline int isxdigit (int _c)
  { return (_ctype+1)[_c] & (_XDIGIT); }

#if !defined (_CTYPE_FUN)
extern __inline__ int _toupper (int _c) { return (_c-'a'+'A'); }
extern __inline__ int _tolower (int _c) { return (_c-'A'+'a'); }
extern __inline__ int toupper(int _c)
  {return (islower(_c) ? _toupper(_c) : _c);}
extern __inline__ int tolower(int _c)
  {return (isupper(_c) ? _tolower(_c) : _c);}
#endif

#if defined (__cplusplus)
}
#endif

#endif /* not _CTYPE_H */
