/*
    Application entry point.

    Copyright (c) 1992-1998 by Eberhard Mattes
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    This is the routine that gets control first.
    It should prepare argc/argv/envp and call the
    main function.
*/

#include <emx/asm386.h>

	.globl  __text
	.globl  __data

	.text

__text:
	call    ___init_app
	cld
	leal	(%esp), %edi    /* argv[] */
	movl	%edi, _STD(environ)
	movl	%edi, __org_environ
	pushl	%edi            /* envp */
	call	L_ptr_tbl
	pushl	%edi            /* argv */
	call	L_ptr_tbl
	pushl	%ecx            /* argc */
#if defined (MCRT0)
	pushl   $__mcleanup
	call    _atexit
	pushl   $__etext
	pushl   $__text
	call    _monstartup
	addl    $3*4, %esp
#endif
	call    __CRT_init
	call    _main
	addl    $3*4, %esp
	pushl   %eax
	call    _exit
1:	jmp     1b		/* Just in case exit() returns :-) */

L_ptr_tbl:
	xorl    %eax, %eax
	movl    $-1, %ecx
2:	incl    %ecx
	scasl
	jne     2b
	ret

	.data

__data:
	.long	0xba0bab	// Magic number (error detection)
	.long   __os2dll	// list of OS/2 DLL references

	.stabs  "__os2dll", 21, 0, 0, 0xffffffff
	.stabs  "___CTOR_LIST__", 21, 0, 0, 0xffffffff
	.stabs  "___DTOR_LIST__", 21, 0, 0, 0xffffffff
	.stabs  "___crtinit1__", 21, 0, 0, 0xffffffff
	.stabs  "___crtexit1__", 21, 0, 0, 0xffffffff
	.stabs  "___eh_frame__", 21, 0, 0, 0xffffffff
	.stabs  "___eh_init__", 21, 0, 0, 0xffffffff
	.stabs  "___eh_term__", 21, 0, 0, 0xffffffff

