/* $Id: dllinit.c 547 2003-08-07 23:21:41Z bird $ */
/** @file
 * Default DLL init and termination code.
 */

#include <emx/startup.h>
extern int _CRT_init (void);
extern void __ctordtorInit (void);
extern void __ctordtorTerm (void);

/**
 * This is the typical DLL startup code. __ehInitDLL and __ehTermDLL is called
 * are for exception handler stuff in gcc, the two functions will be linked if
 * there is exception handler info in the module. (Btw. if these calls wasn't
 * made we would fail to catch exceptions in C++ code.)
 * @returns 1 on success.
 * @returns 0 on failure.
 * @param   hmod    Handle of this DLL.
 * @param   flag    0 init.
 *                  1 term.
 * @remark  This function is called from dll0.asm.
 */
unsigned _System _DLL_InitTerm (unsigned hmod, unsigned flag)
{
  switch (flag)
  {
    case 0:
      if (_CRT_init () != 0)
        break;
#if 0 /** @todo Weaks aren't working too well with ld at the moment.
       * Andy added the calls to the static constructor and destructor lists
       * which means we don't guarantee that throw/catch works during init
       * and destruction of static objects. Don't belive it'll cause any
       * trouble. Before too long we should put back this code.
       */
      if (__ehInitDLL)
        __ehInitDLL ();
#endif
      __ctordtorInit ();
      return 1;
    case 1:
      __ctordtorTerm ();
#if 0 /* weaks aren't working at the moment */
      if (__ehTermDLL)
        __ehTermDLL ();
#endif
      return 1;
  }
  return 0;
}
