/* This piece of code is linked into the program from gcc.a if any of the
   object files that are linked together use exception (e.g. have exception
   frame tables inside). The code automatically registers all exception
   tables into a central list (meant to be placed inside gcc*.dll),
   upon program exit these lists are deregistered. */

extern int __eh_frame__;
extern void __register_frame_table (void *begin);
extern void __deregister_frame (void *begin);

/** Exception handler stuff init indicator. 0 means not inited, 1 means inited. */
static int inited;

/**
 * Inits exception handler stuff.
 * Intended external caller is _DLL_InitTerm.
 */
void __attribute__((constructor)) __ehInit (void)
{
  if (!inited)
    {
      int *ptr = &__eh_frame__;
      inited = 1;
      __register_frame_table (&ptr [*ptr == -2 ? 1 : 2]);
    }
}

/**
 * Terminates exception handler stuff.
 * Intended external caller is _DLL_InitTerm.
 */
void __attribute__((destructor)) __ehTerm (void)
{
  if (inited)
    {
      int *ptr = &__eh_frame__;
      inited = 0;
      __deregister_frame (&ptr [*ptr == -2 ? 1 : 2]);
    }
}
