/* localtim.c (emx+gcc) -- Copyright (c) 1990-1999 by Eberhard Mattes */

#include "libc-alias.h"
#include <time.h>
#include <emx/thread.h>
#include <emx/time.h>

struct tm *_STD(localtime) (const time_t *t)
{
  struct _thread *tp = _thread ();
  return _localtime (&tp->_th_gmtime_buf, t);
}

/* mkstd.awk: NOUNDERSCORE(localtime) */
struct tm *_localtime (struct tm *dst, const time_t *t)
{
  time_t lt;
  int isdst;
  struct tm *p;

  if (!_tzset_flag) tzset ();
  lt = *t;
  isdst = _gmt2loc (&lt);
  p = _gmtime (dst, &lt);
  p->tm_isdst = isdst;
  return p;
}
