/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Returns a pointer to the last component of a pathname.
    The pathname is never modified (GNU/Linux compatible behaviour).
*/

#include "libc-alias.h"
#include <string.h>
#include <ctype.h>

char *__gnu_basename (const char *name)
{
  const char *ret;

  /* Skip over the disk name in MSDOS pathnames. */
  if (isalpha (name [0]) && (name [1] == ':'))
    name += 2;

  for (ret = name; *name; name++)
    if (*name == '/' || *name == '\\')
      ret = name + 1;

  return (char *)ret;
}
