/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Standard XPG dirname() implementation.
    This function complements the XPG basename() function. If path is
    NULL, a empty string, or does not contain slashes (forward or backward),
    "." is returned. Otherwise it returns a pointer to the directory part
    of the pathname; the last slash in the pathname is replaced with zero.
*/

#include "libc-alias.h"
#include <libgen.h>
#include <string.h>

char *_STD(dirname) (char *pathname)
{
  char *x;

  if (!pathname || !*pathname)
    return ".";

  x = strchr (pathname, 0);
  while ((x > pathname) && (x [-1] != '/') && (x [-1] != '\\') && (x [-1] != ':'))
    x--;
  while ((x > pathname) && ((x [-1] == '/') || (x [-1] == '\\')))
    x--;

  if (x == pathname)
    return ".";

  *x = 0;
  return pathname;
}
