/ signbit.s (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes

#include <emx/asm386.h>

#define FUNC    MATHSUFFIX3(signbit)

        .globl  FUNC

        .text

        ALIGN

#if defined (LONG_DOUBLE)

/ int __signbitl (long double x)

#define x0      4(%esp)
#define x9      13(%esp)

FUNC:
        PROFILE_NOFRAME
        xorl    %eax, %eax
        testb   $0x80, x9
        setnz   %al
        EPILOGUE(FUNC)

#elif defined (FLOAT)

/ int __signbitf (float x)

#define x0      4(%esp)
#define x3      7(%esp)

FUNC:
        PROFILE_NOFRAME
        xorl    %eax, %eax
        testb   $0x80, x3
        setnz   %al
        EPILOGUE(FUNC)

#else

/ int __signbit (double x)

#define x0      4(%esp)
#define x7      11(%esp)

FUNC:
        PROFILE_NOFRAME
        xorl    %eax, %eax
        testb   $0x80, x7
        setnz   %al
        EPILOGUE(FUNC)

#endif
