/ isfin.s (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes

#include <emx/asm386.h>

#define FUNC    MATHSUFFIX3(isfinite)

        .globl  FUNC

        .text

        ALIGN

#if defined (LONG_DOUBLE)

/ int __isfinitel (long double x)

#define x       4(%esp)

FUNC:
        PROFILE_NOFRAME
        fldt    x
        fxam
        fstsw   %ax
        fstp    %st(0)
        movb    %ah, %al
        andl    $0x47, %eax
        movb    Ltable(%eax), %al
        EPILOGUE(FUNC)

Ltable: .byte   0               /* +unnormal, not supported by 387 */
        .byte   0               /* -unnormal, not supported by 387 */
        .byte   0               /* +NaN */
        .byte   0               /* -NaN */
        .byte   1               /* +normal */
        .byte   0               /* +infinity */
        .byte   1               /* -normal */
        .byte   0               /* -infinity */
        .byte   0, 0, 0, 0, 0, 0, 0, 0
        .byte   0, 0, 0, 0, 0, 0, 0, 0
        .byte   0, 0, 0, 0, 0, 0, 0, 0
        .byte   0, 0, 0, 0, 0, 0, 0, 0
        .byte   0, 0, 0, 0, 0, 0, 0, 0
        .byte   0, 0, 0, 0, 0, 0, 0, 0
        .byte   0, 0, 0, 0, 0, 0, 0, 0
        .byte   1               /* +zero */
        .byte   0          /* empty */
        .byte   1               /* -zero */
        .byte   0          /* empty */
        .byte   1               /* +denormal */
        .byte   0          /* empty, not supported by 387 */
        .byte   1               /* -denormal */
        .byte   0          /* empty, not supported by 387 */

#elif defined (FLOAT)

/ int __isfinitef (float x)

#define x       4(%esp)

FUNC:
        PROFILE_NOFRAME
        movl    x, %edx
        xorl    %eax, %eax
        andl    $0x7fffffff, %edx
        cmpl    $0x7f800000, %edx
        setb    %al
        EPILOGUE(FUNC)

#else

/ int __isfinite (double x)

#define x0      4(%esp)
#define x4      8(%esp)

FUNC:
        PROFILE_NOFRAME
        movl    x4, %edx
        xorl    %eax, %eax
        andl    $0x7ff00000, %edx
        cmpl    $0x7ff00000, %edx
        setne   %al
        EPILOGUE(FUNC)

#endif
