/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Locale-dependent time formatting strings.
*/

#define __INTERNAL_DEFS
#include <sys/locale.h>
#include <string.h>

struct __locale_time __locale_time =
{
  date_time_fmt: "%a %b %d %H:%M:%S %Y",
  date_fmt: "%m/%d/%y",
  time_fmt: "%H:%M:%S",
  am: "AM",
  pm: "PM"
};

static void init_charptr_array (int count, const char *str, char **array)
{
  int idx = 0;
  while (count--)
  {
    array [idx++] = (char *)str;
    str = strchr (str, 0) + 1;
  } /* endwhile */
}

static void __attribute__((constructor)) __locale_time_init ()
{
  init_charptr_array (12,
    "Jan\0Feb\0Mar\0Apr\0May\0Jun\0Jul\0Aug\0Sep\0Oct\0Nov\0Dec",
    __locale_time.smonths);
  init_charptr_array (12,
    "January\0February\0March\0April\0May\0June\0July\0August\0September\0October\0November\0December",
    __locale_time.lmonths);
  init_charptr_array (7,
    "Sun\0Mon\0Tue\0Wed\0Thu\0Fri\0Sat",
    __locale_time.swdays);
  init_charptr_array (7,
    "Sunday\0Monday\0Tuesday\0Wednesday\0Thursday\0Friday\0Saturday",
    __locale_time.lwdays);
}
