/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Global locale information structure.
*/

#define __INTERNAL_DEFS
#include <sys/locale.h>

const char *__locale_C = "C";

/* This is the global variable containing basic information
   about current locale. If there is at least one reference to it,
   the application will also pull in the __locale_init() function
   which will automatically run at application start time and will
   initialize this variable to default "C" locale. */
struct __locale_global __locale =
{
  lock: 0
};

static void __attribute__((constructor)) __locale_init ()
{
  int i;

  for (i = LC_ALL; i < __LC_COUNT; i++)
    __locale.name [i + 1] = (char *)__locale_C;
}
