/*
    Locale support implementation through OS/2 Unicode API.
    Copyright (c) 2003 InnoTek Systemberatung GmbH

    For conditions of distribution and use, see the file COPYING.

    Helper function: convert a MBCS character to a Unicode character.
    Returns 0 or the length of the MBCS character in bytes.
*/

#include <uconv.h>

int __to_ucs (UconvObject uconv_obj, const unsigned char *sbcs, size_t len,
  UniChar *ucs)
{
  void *inbuf = (void *)sbcs;
  UniChar *outbuf = ucs;
  size_t nonid, in_left = len, out_left = 1;

  int ret = UniUconvToUcs (uconv_obj, &inbuf, &in_left, &outbuf, &out_left,
    &nonid);

  if ((ret && (ret != ULS_BUFFERFULL)) || nonid || out_left)
    return 0;

  return len - in_left;
}
